/****************************************************************************
 * crypto/spr.h
 * $OpenBSD: spr.h,v 1.2 2002/10/27 13:24:26 miod Exp $
 * lib/des/spr.h
 * Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 *
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 *
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed
 *    by Eric Young (eay@mincom.oz.au)
 *
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.
 * i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <sys/types.h>

static const uint32_t des_sptrans[8][64] =
{
  {
    /* nibble 0 */

    0x00820200l, 0x00020000l, 0x80800000l, 0x80820200l,
    0x00800000l, 0x80020200l, 0x80020000l, 0x80800000l,
    0x80020200l, 0x00820200l, 0x00820000l, 0x80000200l,
    0x80800200l, 0x00800000l, 0x00000000l, 0x80020000l,
    0x00020000l, 0x80000000l, 0x00800200l, 0x00020200l,
    0x80820200l, 0x00820000l, 0x80000200l, 0x00800200l,
    0x80000000l, 0x00000200l, 0x00020200l, 0x80820000l,
    0x00000200l, 0x80800200l, 0x80820000l, 0x00000000l,
    0x00000000l, 0x80820200l, 0x00800200l, 0x80020000l,
    0x00820200l, 0x00020000l, 0x80000200l, 0x00800200l,
    0x80820000l, 0x00000200l, 0x00020200l, 0x80800000l,
    0x80020200l, 0x80000000l, 0x80800000l, 0x00820000l,
    0x80820200l, 0x00020200l, 0x00820000l, 0x80800200l,
    0x00800000l, 0x80000200l, 0x80020000l, 0x00000000l,
    0x00020000l, 0x00800000l, 0x80800200l, 0x00820200l,
    0x80000000l, 0x80820000l, 0x00000200l, 0x80020200l,
  },
  {
    /* nibble 1 */

    0x10042004l, 0x00000000l, 0x00042000l, 0x10040000l,
    0x10000004l, 0x00002004l, 0x10002000l, 0x00042000l,
    0x00002000l, 0x10040004l, 0x00000004l, 0x10002000l,
    0x00040004l, 0x10042000l, 0x10040000l, 0x00000004l,
    0x00040000l, 0x10002004l, 0x10040004l, 0x00002000l,
    0x00042004l, 0x10000000l, 0x00000000l, 0x00040004l,
    0x10002004l, 0x00042004l, 0x10042000l, 0x10000004l,
    0x10000000l, 0x00040000l, 0x00002004l, 0x10042004l,
    0x00040004l, 0x10042000l, 0x10002000l, 0x00042004l,
    0x10042004l, 0x00040004l, 0x10000004l, 0x00000000l,
    0x10000000l, 0x00002004l, 0x00040000l, 0x10040004l,
    0x00002000l, 0x10000000l, 0x00042004l, 0x10002004l,
    0x10042000l, 0x00002000l, 0x00000000l, 0x10000004l,
    0x00000004l, 0x10042004l, 0x00042000l, 0x10040000l,
    0x10040004l, 0x00040000l, 0x00002004l, 0x10002000l,
    0x10002004l, 0x00000004l, 0x10040000l, 0x00042000l,
  },
  {
    /* nibble 2 */

    0x41000000l, 0x01010040l, 0x00000040l, 0x41000040l,
    0x40010000l, 0x01000000l, 0x41000040l, 0x00010040l,
    0x01000040l, 0x00010000l, 0x01010000l, 0x40000000l,
    0x41010040l, 0x40000040l, 0x40000000l, 0x41010000l,
    0x00000000l, 0x40010000l, 0x01010040l, 0x00000040l,
    0x40000040l, 0x41010040l, 0x00010000l, 0x41000000l,
    0x41010000l, 0x01000040l, 0x40010040l, 0x01010000l,
    0x00010040l, 0x00000000l, 0x01000000l, 0x40010040l,
    0x01010040l, 0x00000040l, 0x40000000l, 0x00010000l,
    0x40000040l, 0x40010000l, 0x01010000l, 0x41000040l,
    0x00000000l, 0x01010040l, 0x00010040l, 0x41010000l,
    0x40010000l, 0x01000000l, 0x41010040l, 0x40000000l,
    0x40010040l, 0x41000000l, 0x01000000l, 0x41010040l,
    0x00010000l, 0x01000040l, 0x41000040l, 0x00010040l,
    0x01000040l, 0x00000000l, 0x41010000l, 0x40000040l,
    0x41000000l, 0x40010040l, 0x00000040l, 0x01010000l,
  },
  {
    /* nibble 3 */

    0x00100402l, 0x04000400l, 0x00000002l, 0x04100402l,
    0x00000000l, 0x04100000l, 0x04000402l, 0x00100002l,
    0x04100400l, 0x04000002l, 0x04000000l, 0x00000402l,
    0x04000002l, 0x00100402l, 0x00100000l, 0x04000000l,
    0x04100002l, 0x00100400l, 0x00000400l, 0x00000002l,
    0x00100400l, 0x04000402l, 0x04100000l, 0x00000400l,
    0x00000402l, 0x00000000l, 0x00100002l, 0x04100400l,
    0x04000400l, 0x04100002l, 0x04100402l, 0x00100000l,
    0x04100002l, 0x00000402l, 0x00100000l, 0x04000002l,
    0x00100400l, 0x04000400l, 0x00000002l, 0x04100000l,
    0x04000402l, 0x00000000l, 0x00000400l, 0x00100002l,
    0x00000000l, 0x04100002l, 0x04100400l, 0x00000400l,
    0x04000000l, 0x04100402l, 0x00100402l, 0x00100000l,
    0x04100402l, 0x00000002l, 0x04000400l, 0x00100402l,
    0x00100002l, 0x00100400l, 0x04100000l, 0x04000402l,
    0x00000402l, 0x04000000l, 0x04000002l, 0x04100400l,
  },
  {
    /* nibble 4 */

    0x02000000l, 0x00004000l, 0x00000100l, 0x02004108l,
    0x02004008l, 0x02000100l, 0x00004108l, 0x02004000l,
    0x00004000l, 0x00000008l, 0x02000008l, 0x00004100l,
    0x02000108l, 0x02004008l, 0x02004100l, 0x00000000l,
    0x00004100l, 0x02000000l, 0x00004008l, 0x00000108l,
    0x02000100l, 0x00004108l, 0x00000000l, 0x02000008l,
    0x00000008l, 0x02000108l, 0x02004108l, 0x00004008l,
    0x02004000l, 0x00000100l, 0x00000108l, 0x02004100l,
    0x02004100l, 0x02000108l, 0x00004008l, 0x02004000l,
    0x00004000l, 0x00000008l, 0x02000008l, 0x02000100l,
    0x02000000l, 0x00004100l, 0x02004108l, 0x00000000l,
    0x00004108l, 0x02000000l, 0x00000100l, 0x00004008l,
    0x02000108l, 0x00000100l, 0x00000000l, 0x02004108l,
    0x02004008l, 0x02004100l, 0x00000108l, 0x00004000l,
    0x00004100l, 0x02004008l, 0x02000100l, 0x00000108l,
    0x00000008l, 0x00004108l, 0x02004000l, 0x02000008l,
  },
  {
    /* nibble 5 */

    0x20000010l, 0x00080010l, 0x00000000l, 0x20080800l,
    0x00080010l, 0x00000800l, 0x20000810l, 0x00080000l,
    0x00000810l, 0x20080810l, 0x00080800l, 0x20000000l,
    0x20000800l, 0x20000010l, 0x20080000l, 0x00080810l,
    0x00080000l, 0x20000810l, 0x20080010l, 0x00000000l,
    0x00000800l, 0x00000010l, 0x20080800l, 0x20080010l,
    0x20080810l, 0x20080000l, 0x20000000l, 0x00000810l,
    0x00000010l, 0x00080800l, 0x00080810l, 0x20000800l,
    0x00000810l, 0x20000000l, 0x20000800l, 0x00080810l,
    0x20080800l, 0x00080010l, 0x00000000l, 0x20000800l,
    0x20000000l, 0x00000800l, 0x20080010l, 0x00080000l,
    0x00080010l, 0x20080810l, 0x00080800l, 0x00000010l,
    0x20080810l, 0x00080800l, 0x00080000l, 0x20000810l,
    0x20000010l, 0x20080000l, 0x00080810l, 0x00000000l,
    0x00000800l, 0x20000010l, 0x20000810l, 0x20080800l,
    0x20080000l, 0x00000810l, 0x00000010l, 0x20080010l,
  },
  {
    /* nibble 6 */

    0x00001000l, 0x00000080l, 0x00400080l, 0x00400001l,
    0x00401081l, 0x00001001l, 0x00001080l, 0x00000000l,
    0x00400000l, 0x00400081l, 0x00000081l, 0x00401000l,
    0x00000001l, 0x00401080l, 0x00401000l, 0x00000081l,
    0x00400081l, 0x00001000l, 0x00001001l, 0x00401081l,
    0x00000000l, 0x00400080l, 0x00400001l, 0x00001080l,
    0x00401001l, 0x00001081l, 0x00401080l, 0x00000001l,
    0x00001081l, 0x00401001l, 0x00000080l, 0x00400000l,
    0x00001081l, 0x00401000l, 0x00401001l, 0x00000081l,
    0x00001000l, 0x00000080l, 0x00400000l, 0x00401001l,
    0x00400081l, 0x00001081l, 0x00001080l, 0x00000000l,
    0x00000080l, 0x00400001l, 0x00000001l, 0x00400080l,
    0x00000000l, 0x00400081l, 0x00400080l, 0x00001080l,
    0x00000081l, 0x00001000l, 0x00401081l, 0x00400000l,
    0x00401080l, 0x00000001l, 0x00001001l, 0x00401081l,
    0x00400001l, 0x00401080l, 0x00401000l, 0x00001001l,
  },
  {
    /* nibble 7 */

    0x08200020l, 0x08208000l, 0x00008020l, 0x00000000l,
    0x08008000l, 0x00200020l, 0x08200000l, 0x08208020l,
    0x00000020l, 0x08000000l, 0x00208000l, 0x00008020l,
    0x00208020l, 0x08008020l, 0x08000020l, 0x08200000l,
    0x00008000l, 0x00208020l, 0x00200020l, 0x08008000l,
    0x08208020l, 0x08000020l, 0x00000000l, 0x00208000l,
    0x08000000l, 0x00200000l, 0x08008020l, 0x08200020l,
    0x00200000l, 0x00008000l, 0x08208000l, 0x00000020l,
    0x00200000l, 0x00008000l, 0x08000020l, 0x08208020l,
    0x00008020l, 0x08000000l, 0x00000000l, 0x00208000l,
    0x08200020l, 0x08008020l, 0x08008000l, 0x00200020l,
    0x08208000l, 0x00000020l, 0x00200020l, 0x08008000l,
    0x08208020l, 0x00200000l, 0x08200000l, 0x08000020l,
    0x00208000l, 0x00008020l, 0x08008020l, 0x08200000l,
    0x00000020l, 0x08208000l, 0x00208020l, 0x00000000l,
    0x08000000l, 0x08200020l, 0x00008000l, 0x00208020l,
  }
};
