/****************************************************************************
 * arch/xtensa/include/xtensa/core_macros.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_XTENSA_INCUDE_XTENSA_CORE_MACRO_H
#define __ARCH_XTENSA_INCUDE_XTENSA_CORE_MACRO_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <arch/chip/core-isa.h>
#include <arch/chip/tie.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define XTHAL_GET_CCOUNT()              ({ int __ccount; \
                                        __asm__ __volatile__("rsr.ccount %0":\
                                        "=a"(__ccount)); __ccount; })

# define XTHAL_SET_CCOUNT(v)             do { int __ccount = (int)(v); \
                                         __asm__ __volatile__("wsr.ccount %0" :: "a"(__ccount):"memory");\
                                         } while(0)

#endif /* __ARCH_XTENSA_INCUDE_XTENSA_CORE_H */
