/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "c2/C2Utils.h"

namespace org::apache::nifi::minifi::c2 {

bool isC2Enabled(const std::shared_ptr<Configure>& configuration) {
  std::string c2_enable_str;
  configuration->get(minifi::Configuration::nifi_c2_enable, "c2.enable", c2_enable_str);
  return utils::StringUtils::toBool(c2_enable_str).value_or(false);
}

bool isControllerSocketEnabled(const std::shared_ptr<Configure>& configuration) {
  std::string controller_socket_enable_str;
  configuration->get(minifi::Configuration::controller_socket_enable, controller_socket_enable_str);
  return utils::StringUtils::toBool(controller_socket_enable_str).value_or(false);
}

}  // namespace org::apache::nifi::minifi::c2
