/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.ProvidedExtensionsProxy;
import org.netbeans.modules.masterfs.filebasedfs.MasterFileSystemFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObjWindows;
import org.netbeans.modules.masterfs.providers.BaseAnnotationProvider;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ProxyLookup;

public class FileBasedFileSystem
extends FileSystem {
    private static final Logger LOG = Logger.getLogger(FileBasedFileSystem.class.getName());
    private static volatile FileBasedFileSystem INSTANCE;
    private transient RootObj<? extends FileObject> root;
    private final transient StatusImpl status = new StatusImpl();
    private static transient int modificationInProgress;

    public FileBasedFileSystem() {
        if (BaseUtilities.isWindows()) {
            RootObjWindows realRoot = new RootObjWindows();
            this.root = new RootObj<RootObjWindows>(realRoot);
        } else {
            FileObjectFactory factory = FileObjectFactory.getInstance(new File("/"));
            this.root = new RootObj<BaseFileObj>(factory.getRoot());
        }
    }

    public static synchronized boolean isModificationInProgress() {
        return modificationInProgress != 0;
    }

    private static synchronized void setModificationInProgress(boolean started) {
        modificationInProgress = started ? ++modificationInProgress : --modificationInProgress;
    }

    public static void runAsInconsistent(Runnable r) {
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            r.run();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
    }

    public static <Retval> Retval runAsInconsistent(FSCallable<Retval> r) throws IOException {
        Retval retval = null;
        try {
            FileBasedFileSystem.setModificationInProgress(true);
            retval = r.call();
        }
        finally {
            FileBasedFileSystem.setModificationInProgress(false);
        }
        return retval;
    }

    public static Map<File, ? extends FileObjectFactory> factories() {
        return FileObjectFactory.factories();
    }

    public static FileObject getFileObject(File file) {
        return FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public static FileObject getFileObject(File file, FileObjectFactory.Caller caller) {
        FileObjectFactory fs = FileObjectFactory.getInstance(file);
        FileObject retval = null;
        if (fs != null) {
            retval = file.getParentFile() == null && BaseUtilities.isUnix() ? FileBasedFileSystem.getInstance().getRoot() : fs.getValidFileObject(file, caller, true);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileBasedFileSystem getInstance() {
        FileBasedFileSystem fbfs = INSTANCE;
        if (fbfs != null) return fbfs;
        MasterFileSystemFactory fbfsFactory = Lookup.getDefault().lookup(MasterFileSystemFactory.class);
        fbfs = fbfsFactory != null ? fbfsFactory.createFileSystem() : new FileBasedFileSystem();
        Class<FileBasedFileSystem> clazz = FileBasedFileSystem.class;
        synchronized (FileBasedFileSystem.class) {
            FileBasedFileSystem old = INSTANCE;
            if (old != null) return old;
            INSTANCE = fbfs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return fbfs;
        }
    }

    @Override
    public void refresh(final boolean expected) {
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                FileBasedFileSystem.this.refreshImpl(expected);
            }
        };
        try {
            FileBasedFileSystem.getInstance().runAtomicAction(new FileSystem.AtomicAction(){

                @Override
                public void run() throws IOException {
                    FileBasedFileSystem.runAsInconsistent(r);
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    public void refreshImpl(boolean expected) {
        FileObject fo = this.root.getRealRoot();
        if (fo instanceof BaseFileObj) {
            ((BaseFileObj)fo).getFactory().refresh(expected);
        } else if (fo instanceof RootObjWindows) {
            Collection<? extends FileObjectFactory> fcs = FileBasedFileSystem.factories().values();
            for (FileObjectFactory fileObjectFactory : fcs) {
                fileObjectFactory.refresh(expected);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public FileObject getRoot() {
        return this.root;
    }

    @Override
    public FileObject findResource(String name) {
        if (BaseUtilities.isWindows()) {
            if ("".equals(name)) {
                return FileBasedFileSystem.getInstance().getRoot();
            }
        } else {
            name = name.startsWith("/") ? name : "/" + name;
        }
        File f = new File(name);
        if (name.contains("..") || name.contains("./") || name.contains("/.")) {
            f = FileUtil.normalizeFile(f);
        }
        return FileBasedFileSystem.getFileObject(f);
    }

    @Override
    public FileObject getTempFolder() throws IOException {
        FileObject tmpDir = FileUtil.toFileObject(new File(System.getProperty("java.io.tmpdir")));
        if (tmpDir != null && tmpDir.isFolder() && tmpDir.isValid()) {
            return tmpDir;
        }
        throw new IOException("Cannot find temporary folder");
    }

    @Override
    public FileObject createTempFile(FileObject parent, String prefix, String suffix, boolean deleteOnExit) throws IOException {
        if (parent.isFolder() && parent.isValid()) {
            FileObject fo;
            File tmpFile = File.createTempFile(prefix, suffix, FileUtil.toFile(parent));
            if (deleteOnExit) {
                tmpFile.deleteOnExit();
            }
            if ((fo = FileUtil.toFileObject(tmpFile)) != null && fo.isData() && fo.isValid()) {
                return fo;
            }
            tmpFile.delete();
        }
        throw new IOException("Cannot create temporary file");
    }

    @Override
    public Lookup findExtrasFor(Set<FileObject> objects) {
        return this.status.findExtrasFor(objects);
    }

    @Override
    public StatusDecorator getDecorator() {
        return this.status;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerReplace();
    }

    public static class Factory
    implements MasterFileSystemFactory {
        @Override
        public FileBasedFileSystem createFileSystem() {
            return new FileBasedFileSystem();
        }
    }

    public static interface FSCallable<V> {
        public V call() throws IOException;
    }

    private static class SerReplace
    implements Serializable {
        static final long serialVersionUID = -3714631266626840241L;

        private SerReplace() {
        }

        public Object readResolve() throws ObjectStreamException {
            return FileBasedFileSystem.getInstance();
        }
    }

    public class StatusImpl
    implements StatusDecorator,
    LookupListener,
    FileStatusListener {
        protected Lookup.Result<BaseAnnotationProvider> annotationProviders;
        private Collection<? extends BaseAnnotationProvider> previousProviders;

        public StatusImpl() {
            try {
                Class.forName("org.netbeans.modules.masterfs.ui.Init", true, Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template<BaseAnnotationProvider>(BaseAnnotationProvider.class));
            this.annotationProviders.addLookupListener(this);
            this.resultChanged(null);
        }

        public ProvidedExtensions getExtensions() {
            Collection<Object> c = this.previousProviders != null ? Collections.unmodifiableCollection(this.previousProviders) : Collections.emptyList();
            return new ProvidedExtensionsProxy(c);
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            Collection<BaseAnnotationProvider> add;
            Collection<BaseAnnotationProvider> now = this.annotationProviders.allInstances();
            if (this.previousProviders != null) {
                add = new HashSet<BaseAnnotationProvider>(now);
                add.removeAll(this.previousProviders);
                HashSet<? extends BaseAnnotationProvider> toRemove = new HashSet<BaseAnnotationProvider>(this.previousProviders);
                toRemove.removeAll(now);
                for (BaseAnnotationProvider baseAnnotationProvider : toRemove) {
                    baseAnnotationProvider.removeFileStatusListener(this);
                }
            } else {
                add = now;
            }
            for (BaseAnnotationProvider ap : add) {
                try {
                    ap.addFileStatusListener(this);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    Exceptions.printStackTrace(tooManyListenersException);
                }
            }
            this.previousProviders = now;
        }

        public Lookup findExtrasFor(Set<FileObject> foSet) {
            ArrayList<Lookup> arr = new ArrayList<Lookup>();
            for (BaseAnnotationProvider ap : this.annotationProviders.allInstances()) {
                Lookup lkp = ap.findExtrasFor(foSet);
                if (lkp == null) continue;
                arr.add(lkp);
            }
            return new ProxyLookup(arr.toArray(new Lookup[arr.size()]));
        }

        @Override
        public void annotationChanged(FileStatusEvent ev) {
            FileBasedFileSystem.this.fireFileStatusChanged(ev);
        }

        @Override
        public String annotateName(String name, Set<? extends FileObject> files) {
            String retVal = null;
            Iterator<BaseAnnotationProvider> it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                BaseAnnotationProvider ap = it.next();
                retVal = ap.annotateName(name, files);
            }
            if (retVal != null) {
                return retVal;
            }
            return name;
        }

        @Override
        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            String retVal = null;
            Iterator<BaseAnnotationProvider> it = this.annotationProviders.allInstances().iterator();
            while (retVal == null && it.hasNext()) {
                BaseAnnotationProvider ap = it.next();
                retVal = ap.annotateNameHtml(name, files);
            }
            return retVal;
        }
    }
}

