/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.resource;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.AggregatingResourceLoader;
import org.apache.myfaces.trinidad.resource.ClassLoaderResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.CoreRenderKitResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.TrTranslationsResourceLoader;

public class LocaleElementsResourceLoader
extends AggregatingResourceLoader {
    private static String[] _INIT_LIBRARIES = new String[]{"LocaleElements", "Translations"};
    private static final ResourceLoader[] _ResourceLoaders = new ResourceLoader[]{new ClassLoaderResourceLoader(), new TrTranslationsResourceLoader(CoreRenderKitResourceLoader.getLocaleElementsURI("Translations", false))};
    private static final String _NEWLINE_SEPARATOR = "\n";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LocaleElementsResourceLoader.class);

    public LocaleElementsResourceLoader() {
        super("", _INIT_LIBRARIES, (ResourceLoader)new ClassLoaderResourceLoader());
        this.setSeparator(_NEWLINE_SEPARATOR);
    }

    protected URL findResource(String path) throws IOException {
        return this.getURL(path);
    }

    protected URL getURL(String path) throws IOException {
        String[] _LIBRARIES = this._getLibraries();
        int len = _LIBRARIES.length;
        ArrayList<URL> urls = new ArrayList<URL>(len);
        for (int i = 0; i < len; ++i) {
            URL u = _ResourceLoaders[i].getResource(_LIBRARIES[i]);
            if (u != null) {
                urls.add(u);
                continue;
            }
            _LOG.warning("RESOURCE_NOT_FOUND", new Object[]{_LIBRARIES[i], path});
        }
        urls.trimToSize();
        URL[] urlArray = urls.toArray(new URL[0]);
        AggregatingResourceLoader.AggregatingURLStreamHandler handler = new AggregatingResourceLoader.AggregatingURLStreamHandler((AggregatingResourceLoader)this, urlArray, _NEWLINE_SEPARATOR);
        return new URL("aggregating", null, -1, path, (URLStreamHandler)handler);
    }

    protected String getContentType(URLConnection conn) {
        return "text/javascript";
    }

    private String[] _getLibraries() {
        String[] _LIBRARIES = new String[]{"META-INF" + CoreRenderKitResourceLoader.getLocaleElementsURI("LocaleElements", false), "META-INF" + CoreRenderKitResourceLoader.getLocaleElementsURI("Translations", false)};
        return _LIBRARIES;
    }
}

