/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.IndexedValueExpression;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.webapp.TrinidadTagSupport;

public class ForEachTag
extends TrinidadTagSupport {
    private int _currentBegin;
    private int _currentIndex;
    private int _currentEnd;
    private int _currentStep;
    private int _currentCount;
    private boolean _isFirst;
    private boolean _isLast;
    private ValueExpression _items;
    private Object _itemsValue;
    private ValueExpression _beginVE;
    private ValueExpression _endVE;
    private ValueExpression _stepVE;
    private Integer _begin;
    private Integer _end;
    private Integer _step;
    private String _var;
    private String _varStatus;
    private ValueExpression _previousDeferredVar;
    private ValueExpression _previousDeferredVarStatus;
    private Map<String, Object> _propertyReplacementMap;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ForEachTag.class);
    private static final long serialVersionUID = 1L;

    public void setItems(ValueExpression items) {
        if (items.isLiteralText()) {
            throw new IllegalArgumentException(_LOG.getMessage("MUST_BE_SIMPLE_JSF_EL_EXPRESSION"));
        }
        this._items = items;
    }

    public void setBegin(ValueExpression begin) {
        this._beginVE = begin;
    }

    public void setEnd(ValueExpression end) {
        this._endVE = end;
    }

    public void setStep(ValueExpression step) {
        this._stepVE = step;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarStatus(String varStatus) {
        this._varStatus = varStatus;
    }

    public int doStartTag() throws JspException {
        this._validateAttributes();
        FacesContext context = FacesContext.getCurrentInstance();
        this._currentBegin = this._begin == null ? 0 : this._begin;
        this._isFirst = true;
        if (null != this._items) {
            int length;
            Object items = this._items.getValue(context.getELContext());
            if (items == null) {
                if (_LOG.isFine()) {
                    _LOG.fine("Items expression " + this._items + " resolved to null.");
                }
                return 0;
            }
            this._itemsValue = items;
            if (items instanceof List) {
                length = ((List)items).size();
            } else if (items.getClass().isArray()) {
                length = Array.getLength(items);
            } else {
                throw new JspException(_LOG.getMessage("MUST_POINT_TO_LIST_OR_ARRAY"));
            }
            if (length == 0) {
                if (_LOG.isFine()) {
                    _LOG.fine("Items found at " + this._items + " is empty.");
                }
                return 0;
            }
            if (length < this._currentBegin) {
                if (_LOG.isFine()) {
                    _LOG.fine("Size of 'items' is less than 'begin'");
                }
                return 0;
            }
            int n = this._currentEnd = this._end == null ? length - 1 : this._end;
            if (length <= this._currentEnd) {
                this._currentEnd = length - 1;
            }
        } else {
            this._currentEnd = this._end == null ? 0 : this._end;
        }
        this._currentIndex = this._currentBegin;
        this._currentCount = 1;
        this._currentStep = this._step == null ? 1 : this._step;
        this._validateRangeAndStep();
        if (this._currentEnd < this._currentIndex) {
            return 0;
        }
        this._isLast = this._currentIndex == this._currentEnd;
        VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
        if (this._var != null) {
            this._previousDeferredVar = vm.resolveVariable(this._var);
        }
        if (null != this._varStatus) {
            this._previousDeferredVarStatus = vm.resolveVariable(this._varStatus);
            this._propertyReplacementMap = new HashMap<String, Object>(9, 1.0f);
            this._propertyReplacementMap.put("begin", this._currentBegin);
            this._propertyReplacementMap.put("end", this._currentEnd);
            this._propertyReplacementMap.put("step", this._currentStep);
            this._propertyReplacementMap.put("count", this._currentCount);
            this._propertyReplacementMap.put("index", this._currentIndex);
            this._propertyReplacementMap.put("first", this._isFirst ? Boolean.TRUE : Boolean.FALSE);
            this._propertyReplacementMap.put("last", this._isLast ? Boolean.TRUE : Boolean.FALSE);
        }
        if (_LOG.isFiner()) {
            _LOG.finer("Iterating from " + this._currentIndex + " to " + this._currentEnd + " by " + this._currentStep);
        }
        this._updateVars();
        return 1;
    }

    public int doAfterBody() {
        this._currentIndex += this._currentStep;
        ++this._currentCount;
        if (null != this._varStatus) {
            if (this._isFirst) {
                this._propertyReplacementMap.put("first", Boolean.FALSE);
                this._isFirst = false;
            }
            boolean bl = this._isLast = this._currentIndex == this._currentEnd;
            if (this._isLast) {
                this._propertyReplacementMap.put("last", this._isLast);
            }
            this._propertyReplacementMap.put("count", this._currentCount);
            this._propertyReplacementMap.put("index", this._currentIndex);
        }
        if (this._currentEnd < this._currentIndex) {
            VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
            if (this._var != null) {
                vm.setVariable(this._var, this._previousDeferredVar);
            }
            if (this._varStatus != null) {
                vm.setVariable(this._varStatus, this._previousDeferredVarStatus);
            }
            return 0;
        }
        this._updateVars();
        return 2;
    }

    public void release() {
        super.release();
        this._begin = null;
        this._end = null;
        this._step = null;
        this._items = null;
        this._itemsValue = null;
        this._var = null;
        this._varStatus = null;
        this._propertyReplacementMap = null;
        this._previousDeferredVar = null;
        this._previousDeferredVarStatus = null;
    }

    private void _updateVars() {
        VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
        if (this._var != null) {
            Object items;
            if (this._items != null) {
                IndexedValueExpression iterated = new IndexedValueExpression(this._items, this._currentIndex);
                vm.setVariable(this._var, (ValueExpression)iterated);
            }
            if ((items = this._itemsValue) != null) {
                Object item = items instanceof List ? ((List)items).get(this._currentIndex) : Array.get(items, this._currentIndex);
                this.pageContext.setAttribute(this._var, item);
            }
        }
        if (this._varStatus != null) {
            this.pageContext.setAttribute(this._varStatus, this._propertyReplacementMap);
            Constants constant = new Constants(new HashMap<String, Object>(this._propertyReplacementMap));
            vm.setVariable(this._varStatus, (ValueExpression)constant);
        }
    }

    private Integer _evaluateInteger(FacesContext context, ValueExpression ve) {
        if (ve == null) {
            return null;
        }
        Object val = ve.getValue(context.getELContext());
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return null;
    }

    private void _validateAttributes() throws JspTagException {
        FacesContext context = FacesContext.getCurrentInstance();
        this._end = this._evaluateInteger(context, this._endVE);
        this._begin = this._evaluateInteger(context, this._beginVE);
        this._step = this._evaluateInteger(context, this._stepVE);
        if (null == this._items && (null == this._begin || null == this._end)) {
            throw new JspTagException("'begin' and 'end' should be specified if 'items' is not specified");
        }
        if (this._var != null && this._var.equals(this._varStatus)) {
            throw new JspTagException("'var' and 'varStatus' should not have the same value");
        }
    }

    private void _validateRangeAndStep() throws JspTagException {
        if (this._currentBegin < 0) {
            throw new JspTagException("'begin' < 0");
        }
        if (this._currentStep < 1) {
            throw new JspTagException("'step' < 1");
        }
    }

    private static class Constants
    extends ValueExpression
    implements Serializable {
        private Object _o;
        private static final long serialVersionUID = 1L;

        public Constants(Object o) {
            this._o = o;
        }

        public Object getValue(ELContext context) {
            return this._o;
        }

        public void setValue(ELContext context, Object value) {
            throw new PropertyNotWritableException();
        }

        public boolean isReadOnly(ELContext context) {
            return true;
        }

        public Class getType(ELContext context) {
            return this._o.getClass();
        }

        public Class getExpectedType() {
            return this._o.getClass();
        }

        public String getExpressionString() {
            return null;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return this._o.hashCode();
        }

        public boolean isLiteralText() {
            return true;
        }
    }
}

