/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.ComponentContextChange;
import org.apache.myfaces.trinidad.context.ComponentContextManager;
import org.apache.myfaces.trinidad.context.SuspendCallback;
import org.apache.myfaces.trinidad.context.SuspendedContextChanges;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

final class ComponentContextManagerImpl
extends ComponentContextManager {
    private Queue<ComponentContextChange> _stack;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ComponentContextManagerImpl.class);

    ComponentContextManagerImpl() {
    }

    @Override
    public void pushChange(ComponentContextChange change) {
        if (this._stack == null) {
            this._stack = Collections.asLifoQueue(new ArrayDeque());
        }
        this._stack.offer(change);
        if (_LOG.isFine()) {
            _LOG.fine("Component context change pushed onto the stack. Change: {0}. New stack size: {1}", new Object[]{change, this._stack.size()});
        }
    }

    @Override
    public ComponentContextChange popChange() throws IllegalStateException {
        if (this._stack == null) {
            throw new IllegalStateException("No changes to pop");
        }
        ComponentContextChange change = this._stack.poll();
        if (_LOG.isFine()) {
            _LOG.fine("Component context change popped from the stack. Popped change: {0}. New head of stack: {1}. New stack size: {2}", new Object[]{change, this._stack.peek(), this._stack.size()});
        }
        if (this._stack.isEmpty()) {
            this._stack = null;
        }
        return change;
    }

    @Override
    public ComponentContextChange peekChange() {
        return this._stack == null ? null : this._stack.peek();
    }

    @Override
    public SuspendedContextChanges suspend(FacesContext facesContext) {
        if (this._stack == null) {
            _LOG.fine("Stack with no changes has been suspended");
            return new SuspendedContextChangesImpl(new ArrayDeque<ComponentContextChange>(0));
        }
        ArrayDeque<ComponentContextChange> q = new ArrayDeque<ComponentContextChange>(this._stack.size());
        for (ComponentContextChange change : this._stack) {
            change.suspend(facesContext);
            q.offer(change);
        }
        this._stack = null;
        if (_LOG.isFine()) {
            _LOG.fine("Component change stack has been suspended. Number of suspended changes: {0}", new Object[]{q.size()});
        }
        return new SuspendedContextChangesImpl(q);
    }

    @Override
    public SuspendedContextChanges partialSuspend(FacesContext facesContext, SuspendCallback callback) {
        ComponentContextChange change;
        SuspendCallback.SuspendResult result;
        if (this._stack == null) {
            _LOG.fine("Stack with no changes has been partially suspended");
            return new SuspendedContextChangesImpl(new ArrayDeque<ComponentContextChange>(0));
        }
        ArrayDeque<ComponentContextChange> q = new ArrayDeque<ComponentContextChange>(this._stack.size());
        Iterator iter = this._stack.iterator();
        while (iter.hasNext() && (result = callback.getSuspendResult(change = (ComponentContextChange)iter.next())) != SuspendCallback.SuspendResult.STOP) {
            iter.remove();
            change.suspend(facesContext);
            q.offer(change);
            if (result != SuspendCallback.SuspendResult.STOP_AFTER_CURRENT) continue;
            break;
        }
        if (_LOG.isFine()) {
            _LOG.fine("Component change stack has been partially suspended. Number of suspended changes: {0}. New stack size: {1}", new Object[]{q.size(), this._stack.size()});
        }
        if (this._stack.isEmpty()) {
            this._stack = null;
        }
        return new SuspendedContextChangesImpl(q);
    }

    @Override
    public Iterator<ComponentContextChange> resume(FacesContext facesContext, SuspendedContextChanges suspendedChanges) {
        assert (suspendedChanges instanceof SuspendedContextChangesImpl) : "Invalid suspend changes";
        SuspendedContextChangesImpl suspendedChangesImpl = (SuspendedContextChangesImpl)suspendedChanges;
        if (this._stack == null) {
            this._stack = Collections.asLifoQueue(new ArrayDeque());
        }
        Iterator iter = suspendedChangesImpl._suspendedStack.descendingIterator();
        while (iter.hasNext()) {
            ComponentContextChange change = (ComponentContextChange)iter.next();
            change.resume(facesContext);
            this._stack.offer(change);
        }
        if (_LOG.isFine()) {
            _LOG.fine("Component change stack has been resumed. Number of resumed changes: {0}. New stack size: {1}", new Object[]{suspendedChangesImpl._suspendedStack.size(), this._stack.size()});
        }
        return suspendedChangesImpl._suspendedStack.descendingIterator();
    }

    private static class SuspendedContextChangesImpl
    extends SuspendedContextChanges {
        private Deque<ComponentContextChange> _suspendedStack;

        SuspendedContextChangesImpl(Deque<ComponentContextChange> suspendedStack) {
            this._suspendedStack = suspendedStack;
        }
    }
}

