/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.aliasbean;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.webapp.UIComponentTag;
import org.apache.myfaces.custom.aliasbean.AliasBean;

public class AliasBeanTagHandler
extends ComponentHandler {
    private TagAttribute valueAttr = this.getRequiredAttribute("value");
    private TagAttribute aliasAttr = this.getRequiredAttribute("alias");

    public AliasBeanTagHandler(ComponentConfig tagConfig) {
        super(tagConfig);
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        super.setAttributes(ctx, instance);
        Application app = ctx.getFacesContext().getApplication();
        AliasBean aliasBean = (AliasBean)instance;
        String value = this.valueAttr.getValue();
        if (UIComponentTag.isValueReference((String)value)) {
            aliasBean.setValueBinding("value", app.createValueBinding(this.valueAttr.getValue()));
        } else {
            aliasBean.setValue(value);
        }
        String alias = this.aliasAttr.getValue();
        if (UIComponentTag.isValueReference((String)alias)) {
            aliasBean.setValueBinding("alias", app.createValueBinding(this.aliasAttr.getValue()));
        } else {
            aliasBean.setAlias(alias);
        }
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent component) throws IOException, FacesException, ELException {
        AliasBean aliasBean = (AliasBean)component;
        aliasBean.makeAlias(ctx.getFacesContext());
        super.applyNextHandler(ctx, component);
        aliasBean.removeAlias(ctx.getFacesContext());
    }

    public void onComponentCreated(FaceletContext faceletcontext, UIComponent component, UIComponent parent) {
        parent.getChildren().add(component);
    }
}

