/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.document;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.custom.document.AbstractDocumentRenderer;
import org.apache.myfaces.custom.document.DocumentBody;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.renderkit.html.util.ExtensionsPhaseListener;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

public class DocumentBodyRenderer
extends AbstractDocumentRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.DocumentBody";
    private String BODY_ELEM = "body";
    private String[] ATTRS = new String[]{"onload", "onunload", "onresize", "onkeypress", "style", "styleClass", "id"};
    private final String ONRESIZE = "onresize";
    private final String RESIZE = "resize";

    protected String getHtmlTag() {
        return this.BODY_ELEM;
    }

    protected Class getDocumentClass() {
        return DocumentBody.class;
    }

    protected void openTag(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            if (!behaviors.isEmpty()) {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
            }
            super.openTag(facesContext, writer, uiComponent);
            if (behaviors.isEmpty()) {
                HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            } else {
                writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), null);
            }
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", uiComponent, "load", behaviors, "onload");
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", uiComponent, "unload", behaviors, "onunload");
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onresize", uiComponent, "resize", behaviors, "onresize");
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BODY_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
        } else {
            super.openTag(facesContext, writer, uiComponent);
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.BODY_PASSTHROUGH_ATTRIBUTES);
            HtmlRendererUtils.renderHTMLAttribute(writer, uiComponent, "onresize", "onresize");
        }
    }

    protected void writeBeforeEnd(FacesContext facesContext) throws IOException {
        super.writeBeforeEnd(facesContext);
        AddResource addResource = AddResourceFactory.getInstance(facesContext);
        if (!addResource.requiresBuffer()) {
            ExtensionsPhaseListener.writeCodeBeforeBodyEnd(facesContext);
            facesContext.getExternalContext().getRequestMap().put("org.apache.myfaces.myFacesJavascript", "");
        }
        UIViewRoot root = facesContext.getViewRoot();
        for (UIComponent child : root.getComponentResources(facesContext, "body")) {
            child.encodeAll(facesContext);
        }
    }
}

