/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.captcha.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;

public class CAPTCHAImageGenerator {
    private void drawTextOnImage(Graphics2D graphics, String captchaText) {
        double currentFontStatus = Math.random();
        Font font = currentFontStatus >= 0.5 ? new Font("Arial", 0, 60) : new Font("Arial", 1, 60);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        TextLayout textLayout = new TextLayout(captchaText, font, graphics.getFontRenderContext());
        textLayout.draw(graphics, 50.0f, 60.0f);
    }

    private void applyNoiseOnImage(Graphics2D graphics, int bufferedImageWidth, int bufferedImageHeight, Color startingColor, Color endingColor) {
        this.applyShear(graphics, bufferedImageWidth, bufferedImageHeight, startingColor, endingColor);
        this.drawBrokenLineOnImage(graphics);
    }

    private static void applyCurrentGradientPaint(Graphics2D graphics, int width, int height, Color startingColor, Color endingColor) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, startingColor, width, height, endingColor);
        graphics.setPaint(gradientPaint);
    }

    public void generateImage(OutputStream out, String captchaText, Color startingColor, Color endingColor) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(290, 81, 13);
        Graphics2D graphics = bufferedImage.createGraphics();
        CAPTCHAImageGenerator.applyCurrentGradientPaint(graphics, bufferedImage.getWidth(), bufferedImage.getHeight(), startingColor, endingColor);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.black);
        this.drawTextOnImage(graphics, captchaText);
        this.applyNoiseOnImage(graphics, bufferedImage.getWidth(), bufferedImage.getHeight(), startingColor, endingColor);
        this.drawBorders(graphics, bufferedImage.getWidth(), bufferedImage.getHeight());
        PNGEncodeParam param = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)bufferedImage);
        PNGImageEncoder captchaPNGImage = new PNGImageEncoder(out, param);
        captchaPNGImage.encode((RenderedImage)bufferedImage);
    }

    private void drawThickLineOnImage(Graphics graphics, int x1, int y1, int x2, int y2) {
        int dX = x2 - x1;
        int dY = y2 - y1;
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        int thickness = 2;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        graphics.setColor(Color.black);
        double d = ddy > 0.0 ? 0.5 : -0.5;
        dX = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        dY = (int)(ddy += d);
        xPoints[0] = x1 + dX;
        yPoints[0] = y1 + dY;
        xPoints[1] = x1 - dX;
        yPoints[1] = y1 - dY;
        xPoints[2] = x2 - dX;
        yPoints[2] = y2 - dY;
        xPoints[3] = x2 + dX;
        yPoints[3] = y2 + dY;
        graphics.fillPolygon(xPoints, yPoints, 4);
    }

    private void drawBrokenLineOnImage(Graphics2D graphics) {
        Random random = new Random();
        int yPoint1 = random.nextInt(81);
        int yPoint2 = random.nextInt(81);
        int yPoint3 = 40;
        int yPoint4 = random.nextInt(81);
        int yPoint5 = random.nextInt(81);
        this.drawThickLineOnImage(graphics, 0, yPoint1, 72, yPoint2);
        this.drawThickLineOnImage(graphics, 72, yPoint2, 145, yPoint3);
        this.drawThickLineOnImage(graphics, 145, yPoint3, 217, yPoint4);
        this.drawThickLineOnImage(graphics, 217, yPoint4, 290, yPoint5);
    }

    private double getDelta(int period, double i, double phase, double frames) {
        return (double)(period / 2) * Math.sin(i / (double)period + Math.PI * 2 * phase / frames);
    }

    private void applyShear(Graphics2D graphics, int bufferedImageWidth, int bufferedImageHeight, Color startingColor, Color endingColor) {
        int i;
        int periodValue = 20;
        int numberOfFrames = 15;
        int phaseNumber = 7;
        CAPTCHAImageGenerator.applyCurrentGradientPaint(graphics, bufferedImageWidth, bufferedImageHeight, startingColor, endingColor);
        for (i = 0; i < bufferedImageWidth; ++i) {
            double deltaX = this.getDelta(periodValue, i, phaseNumber, numberOfFrames);
            graphics.copyArea(i, 0, 1, bufferedImageHeight, 0, (int)deltaX);
            graphics.drawLine(i, (int)deltaX, i, 0);
            graphics.drawLine(i, (int)deltaX + bufferedImageHeight, i, bufferedImageHeight);
        }
        for (i = 0; i < bufferedImageHeight; ++i) {
            double deltaY = this.getDelta(periodValue, i, phaseNumber, numberOfFrames);
            graphics.copyArea(0, i, bufferedImageWidth, 1, (int)deltaY, 0);
            graphics.drawLine((int)deltaY, i, 0, i);
            graphics.drawLine((int)deltaY + bufferedImageWidth, i, bufferedImageWidth, i);
        }
    }

    private void drawBorders(Graphics2D graphics, int width, int height) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, 0, width - 1);
        graphics.drawLine(0, 0, width - 1, 0);
        graphics.drawLine(0, height - 1, width, height - 1);
        graphics.drawLine(width - 1, height - 1, width - 1, 0);
    }
}

