/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.myfaces.custom.tree.DefaultMutableTreeNode;
import org.apache.myfaces.custom.tree.MutableTreeNode;
import org.apache.myfaces.custom.tree.TreeNode;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreeModelEvent;
import org.apache.myfaces.custom.tree.model.TreeModelListener;
import org.apache.myfaces.custom.tree.model.TreePath;

public class DefaultTreeModel
implements TreeModel,
Serializable {
    private TreeNode root;
    private LinkedList listeners = new LinkedList();

    public DefaultTreeModel() {
        this(new DefaultMutableTreeNode("Root"));
    }

    public DefaultTreeModel(TreeNode root) {
        this.root = root;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
        node.setUserObject(newValue);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Collection getTreeModelListeners() {
        return this.listeners;
    }

    public void nodeChanged(TreeNode node) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (node != null) {
            TreeNode parent = node.getParent();
            if (parent != null) {
                int index = parent.getIndex(node);
                if (index != -1) {
                    int[] childIndices = new int[]{index};
                    this.nodesChanged(parent, childIndices);
                }
            } else if (node == this.getRoot()) {
                this.nodesChanged(node, null);
            }
        }
    }

    public void nodesChanged(TreeNode node, int[] childIndices) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (node != null) {
            if (childIndices != null) {
                int count = childIndices.length;
                if (count > 0) {
                    Object[] children = new Object[count];
                    for (int i = 0; i < count; ++i) {
                        children[i] = node.getChildAt(childIndices[i]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, children);
                }
            } else if (node == this.root) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (node != null && childIndices != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(node), childIndices, removedChildren);
        }
    }

    public TreeNode[] getPathToRoot(TreeNode node) {
        return this.getPathToRoot(node, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode node, int depth) {
        TreeNode[] answer;
        if (node == null) {
            if (depth == 0) {
                return null;
            }
            answer = new TreeNode[depth];
        } else {
            answer = node == this.root ? new TreeNode[depth] : this.getPathToRoot(node.getParent(), ++depth);
            answer[answer.length - depth] = node;
        }
        return answer;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener listener = (TreeModelListener)iterator.next();
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            listener.treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener listener = (TreeModelListener)iterator.next();
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            listener.treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener listener = (TreeModelListener)iterator.next();
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            listener.treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener listener = (TreeModelListener)iterator.next();
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            listener.treeStructureChanged(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, TreePath path) {
        TreeModelEvent event = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener listener = (TreeModelListener)iterator.next();
            if (event == null) {
                event = new TreeModelEvent(source, path);
            }
            listener.treeStructureChanged(event);
        }
    }
}

