/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.bridge.wrapper;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.RenderRequest;
import javax.portlet.filter.RenderRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRenderRequestWrapper
extends RenderRequestWrapper {
    private Map<String, String[]> mPublicParamMap = null;
    private Map<String, String[]> mPrivateParamMap = null;
    private Map<String, String[]> mCombinedParamMap = null;
    private boolean mCombineParams = true;
    private boolean mPublicParamMapFixed = false;
    private boolean mPrivateParamMapFixed = false;
    private boolean mCombinedParamMapFixed = false;

    public BridgeRenderRequestWrapper(RenderRequest request, Map<String, String[]> privateParams) throws IllegalArgumentException {
        this(request, privateParams, null, true);
    }

    public BridgeRenderRequestWrapper(RenderRequest request, Map<String, String[]> privateParams, Map<String, String[]> publicParams, boolean combineParams) throws IllegalArgumentException {
        super(request);
        this.mPrivateParamMap = new LinkedHashMap<String, String[]>(privateParams != null ? privateParams : Collections.EMPTY_MAP);
        this.mPublicParamMap = new LinkedHashMap<String, String[]>(publicParams != null ? publicParams : Collections.EMPTY_MAP);
        this.mCombinedParamMap = new LinkedHashMap<String, String[]>(this.mPublicParamMap);
        this.mCombinedParamMap.putAll(this.mPrivateParamMap);
        this.mCombineParams = combineParams;
    }

    public String getParameter(String name) {
        String[] params = this.getParameterValues(name);
        if (params != null && params.length > 0) {
            return params[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.mCombinedParamMapFixed) {
            return this.mCombinedParamMap;
        }
        if (!this.mCombineParams) {
            this.mCombinedParamMapFixed = true;
            this.mCombinedParamMap = Collections.unmodifiableMap(this.mCombinedParamMap);
            return this.mCombinedParamMap;
        }
        if (this.mCombinedParamMap == null || this.mCombinedParamMap.isEmpty()) {
            return super.getParameterMap();
        }
        this.mCombinedParamMap.putAll(super.getParameterMap());
        this.mCombinedParamMapFixed = true;
        this.mCombinedParamMap = Collections.unmodifiableMap(this.mCombinedParamMap);
        return this.mCombinedParamMap;
    }

    public Map<String, String[]> getPrivateParameterMap() {
        if (this.mPrivateParamMapFixed) {
            return this.mPrivateParamMap;
        }
        if (!this.mCombineParams) {
            this.mPrivateParamMapFixed = true;
            this.mPrivateParamMap = Collections.unmodifiableMap(this.mPrivateParamMap);
            return this.mPrivateParamMap;
        }
        if (this.mPrivateParamMap == null || this.mPrivateParamMap.isEmpty()) {
            return super.getPrivateParameterMap();
        }
        this.mPrivateParamMap.putAll(super.getPrivateParameterMap());
        this.mPrivateParamMapFixed = true;
        this.mPrivateParamMap = Collections.unmodifiableMap(this.mPrivateParamMap);
        return this.mPrivateParamMap;
    }

    public Map<String, String[]> getPublicParameterMap() {
        if (this.mPublicParamMapFixed) {
            return this.mPublicParamMap;
        }
        if (!this.mCombineParams) {
            this.mPublicParamMapFixed = true;
            this.mPublicParamMap = Collections.unmodifiableMap(this.mPublicParamMap);
            return this.mPublicParamMap;
        }
        if (this.mPublicParamMap == null || this.mPublicParamMap.isEmpty()) {
            return super.getPublicParameterMap();
        }
        this.mPublicParamMap.putAll(super.getPublicParameterMap());
        this.mPublicParamMapFixed = true;
        this.mPublicParamMap = Collections.unmodifiableMap(this.mPublicParamMap);
        return this.mPublicParamMap;
    }
}

