/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyListbox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyListboxRenderer
extends SelectManyRendererBase {
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISelectManyListbox select = (AbstractUISelectManyListbox)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = select.getClientId(facesContext);
        String fieldId = select.getFieldId(facesContext);
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, (UIComponent)select);
        boolean readonly = select.isReadonly();
        boolean disabled = !items.iterator().hasNext() || select.isDisabled() || readonly;
        Markup markup = select.getMarkup();
        Integer size = select.getSize();
        size = Math.max(size != null ? size.intValue() : items.size(), 2);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, select.isRequired());
        HtmlRendererUtils.renderFocus(clientId, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
        writer.writeClassAttribute((CssItem)TobagoClass.SELECT_MANY_LISTBOX, TobagoClass.SELECT_MANY_LISTBOX.createMarkup(select.getMarkup()), new CssItem[]{BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity((UIComponent)select)), BootstrapClass.FORM_CONTROL, select.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null});
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
        Object[] values = select.getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)select);
        HtmlRendererUtils.renderSelectItems((UIInput)select, TobagoClass.SELECT_MANY_LISTBOX__OPTION, items, values, submittedValues, writer, facesContext);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        AbstractUISelectManyListbox select = (AbstractUISelectManyListbox)component;
        return select.getFieldId(facesContext);
    }
}

