/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeConverter.class);
    public static final String CONVERTER_ID = "org.apache.myfaces.tobago.DateTime";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_BOTH = "both";
    private static final String TYPE_CALENDAR = "calendar";
    private static final String TYPE_LOCAL_DATE = "localDate";
    private static final String TYPE_LOCAL_TIME = "localTime";
    private static final String TYPE_LOCAL_DATE_TIME = "localDateTime";
    private static final String TYPE_OFFSET_TIME = "offsetTime";
    private static final String TYPE_OFFSET_DATE_TIME = "offsetDateTime";
    private static final String TYPE_ZONED_DATE_TIME = "zonedDateTime";

    public Object getAsObject(FacesContext facesContext, UIComponent component, String string) throws ConverterException {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String type = this.getType();
        if (TYPE_DATE.equals(type) || TYPE_TIME.equals(type) || TYPE_BOTH.equals(type)) {
            return super.getAsObject(facesContext, component, string);
        }
        if (TYPE_CALENDAR.equals(type)) {
            Locale locale = this.getLocale();
            String pattern = this.getPattern();
            TimeZone timeZone = this.getTimeZone();
            Calendar calendar = component instanceof UIInput && ((UIInput)component).getValue() != null ? (Calendar)((UIInput)component).getValue() : (timeZone != null && locale != null ? Calendar.getInstance(timeZone, locale) : (locale != null ? Calendar.getInstance(locale) : (timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance())));
            SimpleDateFormat sdf = locale != null ? new SimpleDateFormat(pattern, locale) : new SimpleDateFormat(pattern);
            try {
                calendar.setTime(sdf.parse(string));
            }
            catch (ParseException e) {
                throw new ConverterException("string='" + string + "'", (Throwable)e);
            }
            return calendar;
        }
        if (TYPE_LOCAL_DATE.equals(type)) {
            this.logMandatoryPatterns("yMd");
            return this.getDateTimeFormatter().parse((CharSequence)string, LocalDate::from);
        }
        if (TYPE_LOCAL_TIME.equals(type)) {
            this.logMandatoryPatterns("H");
            return this.getDateTimeFormatter().parse((CharSequence)string, LocalTime::from);
        }
        if (TYPE_LOCAL_DATE_TIME.equals(type)) {
            this.logMandatoryPatterns("yMdH");
            return this.getDateTimeFormatter().parse((CharSequence)string, LocalDateTime::from);
        }
        if (TYPE_OFFSET_TIME.equals(type)) {
            this.logMandatoryPatterns("HZ");
            return this.getDateTimeFormatter().parse((CharSequence)string, OffsetTime::from);
        }
        if (TYPE_OFFSET_DATE_TIME.equals(type)) {
            this.logMandatoryPatterns("yMdHZ");
            return this.getDateTimeFormatter().parse((CharSequence)string, OffsetDateTime::from);
        }
        if (TYPE_ZONED_DATE_TIME.equals(type)) {
            this.logMandatoryPatterns("yMdHZ");
            return this.getDateTimeFormatter().parse((CharSequence)string, ZonedDateTime::from);
        }
        throw new ConverterException("invalid type '" + type + "'");
    }

    public String getAsString(FacesContext facesContext, UIComponent component, Object object) throws ConverterException {
        if (object == null) {
            return null;
        }
        String type = this.getType();
        if (TYPE_DATE.equals(type) || TYPE_TIME.equals(type) || TYPE_BOTH.equals(type)) {
            return super.getAsString(facesContext, component, object);
        }
        if (TYPE_CALENDAR.equals(type)) {
            Calendar calendar = (Calendar)object;
            Locale locale = this.getLocale();
            String pattern = this.getPattern();
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
            return sdf.format(calendar.getTime());
        }
        if (TYPE_LOCAL_DATE.equals(type) || TYPE_LOCAL_TIME.equals(type) || TYPE_LOCAL_DATE_TIME.equals(type) || TYPE_OFFSET_TIME.equals(type) || TYPE_OFFSET_DATE_TIME.equals(type) || TYPE_ZONED_DATE_TIME.equals(type)) {
            return this.getDateTimeFormatter().format((TemporalAccessor)object);
        }
        throw new ConverterException("invalid type '" + type + "'");
    }

    private void logMandatoryPatterns(String mandatoryChars) {
        this.logMandatoryPattern(mandatoryChars, "y", "year");
        this.logMandatoryPattern(mandatoryChars, "M", "month");
        this.logMandatoryPattern(mandatoryChars, "d", "day");
        this.logMandatoryPattern(mandatoryChars, "H", "hour");
        this.logMandatoryPattern(mandatoryChars, "Z", "offset");
    }

    private void logMandatoryPattern(String mandatoryChars, String c, String name) {
        String pattern = this.getPattern();
        if (pattern != null && mandatoryChars.contains(c) && !pattern.contains(c)) {
            LOG.error("No char for " + name + " ('" + c + "') in pattern: " + pattern);
        }
    }

    private DateTimeFormatter getDateTimeFormatter() {
        String pattern = this.getPattern();
        if (!StringUtils.isBlank(pattern)) {
            Locale locale = this.getLocale();
            return locale != null ? DateTimeFormatter.ofPattern(pattern, locale) : DateTimeFormatter.ofPattern(pattern);
        }
        throw new ConverterException("no pattern set");
    }
}

