/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets.extension;

import java.io.IOException;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import org.apache.myfaces.tobago.component.UISeparator;

public class SeparatorExtensionHandler
extends ComponentHandler {
    private TagAttribute labelAttribute = this.getAttribute("label");

    public SeparatorExtensionHandler(ComponentConfig config) {
        super(config);
    }

    public void applyNextHandler(FaceletContext faceletContext, UIComponent separator) throws IOException, ELException {
        if (ComponentHandler.isNew((UIComponent)separator)) {
            UIComponent component = (UIComponent)separator.getFacets().remove("label");
            this.nextHandler.apply(faceletContext, component);
            separator.getFacets().put("label", component);
        } else {
            this.nextHandler.apply(faceletContext, separator.getFacet("label"));
        }
    }

    public void onComponentCreated(FaceletContext faceletContext, UIComponent separator, UIComponent parent) {
        Application application = faceletContext.getFacesContext().getApplication();
        UIOutput label = (UIOutput)application.createComponent("org.apache.myfaces.tobago.Label");
        label.setId(separator.getId() + "_tx_label");
        label.setRendererType("Label");
        this.setAttributes(faceletContext, label);
        separator.getFacets().put("label", label);
        if (this.labelAttribute != null) {
            if (this.labelAttribute.isLiteral()) {
                label.setValue((Object)this.labelAttribute.getValue(faceletContext));
            } else {
                ValueExpression expression = this.labelAttribute.getValueExpression(faceletContext, String.class);
                label.setValueExpression("value", expression);
            }
        }
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        if (UISeparator.class.isAssignableFrom(aClass)) {
            metaRuleset.ignore("label");
            return metaRuleset;
        }
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            TagAttribute attr = attrs[i];
            metaRuleset.ignore(attr.getLocalName());
        }
        return metaRuleset;
    }
}

