/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.frameworkAdapter.springBasic;

import org.apache.myfaces.orchestra.frameworkAdapter.basic.BasicFrameworkAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContext;

/**
 * Same as {@link BasicFrameworkAdapter} but lookup the bean using the Spring framework.
 * <p>
 * This makes it possible to configure Orchestra to look up beans from a Spring context
 * even when there is no ServletContext or FacesContext available.
 * 
 * @see BasicFrameworkAdapter
 */
public class SpringBasicFrameworkAdapter extends BasicFrameworkAdapter
{
    private final ServletContext context;

    public SpringBasicFrameworkAdapter(ServletContext context, String conversationMessagerClass)
    {
        super(context, conversationMessagerClass);

        this.context = context;
    }

    public Object getBean(String name)
    {
        ApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext(context);
        if (appContext.containsBean(name))
        {
            return appContext.getBean(name);
        }
        else
        {
            return null;
        }
    }
}
