/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf2.impl.scope.conversation;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import javax.enterprise.context.RequestScoped;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.RestParameters;

@RequestScoped
public class JsfRestParameters
extends RestParameters
implements Serializable {
    private static final long serialVersionUID = 1349109309042072780L;
    private String restId = null;

    public boolean isPostback() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext != null && facesContext.isPostback();
    }

    public String getRestId() {
        if (this.restId == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return null;
            }
            String viewId = this.getViewId(facesContext);
            if (viewId == null) {
                return null;
            }
            this.restId = viewId + "//" + this.getViewParams(facesContext);
        }
        return this.restId;
    }

    private String getViewParams(FacesContext facesContext) {
        Collection currentViewParams = ViewMetadata.getViewParameters((UIViewRoot)facesContext.getViewRoot());
        String viewId = this.getViewId(facesContext);
        if (viewId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(viewId).append("?");
        TreeSet<String> viewParamNames = new TreeSet<String>();
        for (UIViewParameter viewParameter : currentViewParams) {
            String viewParamName = viewParameter.getName();
            viewParamNames.add(viewParamName);
        }
        for (String viewParamName : viewParamNames) {
            String viewParamValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(viewParamName);
            if (viewParamValue == null) {
                viewParamValue = "";
            }
            sb.append(viewParamName).append("=").append(viewParamValue).append("+/+");
        }
        return sb.toString();
    }

    private String getViewId(FacesContext facesContext) {
        UIViewRoot viewRoot;
        String viewId = null;
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null) {
            viewId = viewRoot.getViewId();
        }
        return viewId;
    }
}

