/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.FacesApplicationArtifactHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.context.ExceptionHandlerImpl;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;

public abstract class AbstractContextualStorageHolder<T extends ContextualStorage>
implements Serializable {
    @Inject
    protected FacesApplicationArtifactHolder applicationContextBean;
    @Inject
    protected BeanManager beanManager;
    protected Map<String, T> storageMap;

    @PostConstruct
    public void init() {
        FacesApplicationArtifactHolder appBean;
        this.storageMap = new ConcurrentHashMap<String, T>();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext && (appBean = CDIUtils.get(this.beanManager, FacesApplicationArtifactHolder.class)).getServletContext() != null) {
            appBean.setServletContext((ServletContext)context);
        }
    }

    public Map<String, T> forceNewStorage() {
        Map<String, T> oldStorageMap = this.storageMap;
        this.storageMap = new ConcurrentHashMap<String, T>();
        return oldStorageMap;
    }

    public Map<String, T> getStorageMap() {
        return this.storageMap;
    }

    public T getContextualStorage(String slotId) {
        return this.getContextualStorage(slotId, true);
    }

    public T getContextualStorage(String slotId, boolean create) {
        ContextualStorage storage;
        if (this.storageMap == null) {
            if (!create) {
                return null;
            }
            this.storageMap = new ConcurrentHashMap<String, T>();
        }
        if ((storage = (ContextualStorage)this.storageMap.get(slotId)) == null && create) {
            storage = this.newContextualStorage(slotId);
            this.storageMap.put(slotId, storage);
        }
        return (T)storage;
    }

    protected abstract T newContextualStorage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void preDestroy() {
        Map<String, T> oldContextStorages = this.forceNewStorage();
        if (!oldContextStorages.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
                try {
                    ServletContext servletContext = this.applicationContextBean.getServletContext();
                    StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
                    ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
                    facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
                    for (ContextualStorage contextualStorage : oldContextStorages.values()) {
                        this.destroyAll(contextualStorage, facesContext);
                    }
                }
                finally {
                    facesContext.release();
                }
            } else {
                for (ContextualStorage contextualStorage : oldContextStorages.values()) {
                    this.destroyAll(contextualStorage, facesContext);
                }
            }
        }
    }

    public void destroyAll(FacesContext facesContext) {
        if (this.storageMap == null || this.storageMap.isEmpty()) {
            return;
        }
        Map<String, T> oldContextStorages = this.forceNewStorage();
        for (ContextualStorage contextualStorage : oldContextStorages.values()) {
            this.destroyAll(contextualStorage, facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAll(T contextualStorage, FacesContext facesContext) {
        if (contextualStorage == null) {
            return;
        }
        if (facesContext == null) {
            facesContext = FacesContext.getCurrentInstance();
        }
        boolean tempFacesContext = false;
        if (facesContext == null && this.applicationContextBean.getServletContext() != null) {
            ServletContext servletContext = this.applicationContextBean.getServletContext();
            StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, false);
            ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
            facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ExternalContext)externalContext, exceptionHandler, false);
            tempFacesContext = true;
        }
        try {
            Map<Object, ContextualInstanceInfo<?>> contextMap = ((ContextualStorage)contextualStorage).getStorage();
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
                boolean skip = this.isSkipDestroy(entry);
                if (skip) continue;
                Contextual<?> bean = ((ContextualStorage)contextualStorage).getBean(entry.getKey());
                ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
                if (bean == null || contextualInstanceInfo == null) continue;
                bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
            }
            contextMap.clear();
            ((ContextualStorage)contextualStorage).deactivate();
        }
        finally {
            if (tempFacesContext) {
                facesContext.release();
            }
        }
    }

    protected boolean isSkipDestroy(Map.Entry<Object, ContextualInstanceInfo<?>> entry) {
        return false;
    }

    public void destroyAll(FacesContext context, String slotId) {
        if (this.storageMap == null || this.storageMap.isEmpty()) {
            return;
        }
        ContextualStorage contextualStorage = (ContextualStorage)this.storageMap.remove(slotId);
        this.destroyAll(contextualStorage, context);
    }

    protected static <T extends AbstractContextualStorageHolder> T getInstance(FacesContext facesContext, Class<T> contextManagerClass) {
        return AbstractContextualStorageHolder.getInstance(facesContext, contextManagerClass, false);
    }

    protected static <T extends AbstractContextualStorageHolder> T getInstance(FacesContext facesContext, Class<T> contextManagerClass, boolean create) {
        if (facesContext == null || facesContext.getExternalContext() == null || facesContext.getExternalContext().getSession(false) == null) {
            return null;
        }
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
        if (beanManager == null) {
            return null;
        }
        if (!CDIUtils.isSessionScopeActive(beanManager)) {
            return null;
        }
        AbstractContextualStorageHolder cached = (AbstractContextualStorageHolder)facesContext.getExternalContext().getSessionMap().get(contextManagerClass.getName());
        if (cached == null && (cached = create ? (AbstractContextualStorageHolder)CDIUtils.get(beanManager, contextManagerClass) : (AbstractContextualStorageHolder)CDIUtils.getOptional(beanManager, contextManagerClass)) != null) {
            facesContext.getExternalContext().getSessionMap().put(contextManagerClass.getName(), cached);
        }
        return (T)cached;
    }
}

