/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.PostConstructViewMapEvent;
import jakarta.faces.event.PreDestroyViewMapEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.ViewMapListener;
import jakarta.faces.view.ViewScoped;
import jakarta.inject.Inject;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.lang.Lazy;

public class ViewScopeEventListener
implements ViewMapListener {
    private Lazy<Bridge> bridge = new Lazy<Bridge>(() -> {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (ExternalSpecifications.isCDIAvailable(facesContext.getExternalContext())) {
            BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
            return CDIUtils.get(beanManager, Bridge.class);
        }
        return null;
    });

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (this.bridge.get() != null) {
            this.bridge.get().processEvent(event);
        }
    }

    @ApplicationScoped
    public static class Bridge {
        @Inject
        @Initialized(value=ViewScoped.class)
        private Event<UIViewRoot> viewScopeInitializedEvent;
        @Inject
        @Destroyed(value=ViewScoped.class)
        private Event<UIViewRoot> viewScopeDestroyedEvent;

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            if (event instanceof PostConstructViewMapEvent) {
                this.viewScopeInitializedEvent.fire((Object)((UIViewRoot)event.getSource()));
            }
            if (event instanceof PreDestroyViewMapEvent) {
                this.viewScopeDestroyedEvent.fire((Object)((UIViewRoot)event.getSource()));
            }
        }
    }
}

