/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlBodyRendererBase
extends HtmlRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        if (component instanceof ClientBehaviorHolder) {
            Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            if (!behaviors.isEmpty()) {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
            }
            writer.startElement("body", component);
            if (!behaviors.isEmpty()) {
                writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, CommonPropertyUtils.getCommonPropertiesMarked(component), CommonEventUtils.getCommonEventsMarked(component), component, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
            }
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", component, "load", behaviors, "onload");
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", component, "unload", behaviors, "onunload");
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_ATTRIBUTES_WITHOUT_EVENTS);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
            HtmlRendererUtils.renderHTMLStringAttribute(writer, component, "xmlns", "xmlns");
        } else {
            writer.startElement("body", component);
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_PASSTHROUGH_ATTRIBUTES);
            }
            HtmlRendererUtils.renderHTMLStringAttribute(writer, component, "xmlns", "xmlns");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIViewRoot root = facesContext.getViewRoot();
        List componentResources = root.getComponentResources(facesContext, "body");
        int childrenCount = componentResources.size();
        if (childrenCount > 0) {
            for (int i = 0; i < childrenCount; ++i) {
                UIComponent child = (UIComponent)componentResources.get(i);
                child.encodeAll(facesContext);
            }
        }
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            HtmlRendererUtils.renderUnhandledFacesMessages(facesContext);
        }
        writer.endElement("body");
    }
}

