/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push.cdi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.push.PushContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.cdi.WebsocketScopeManager;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;

public class PushContextImpl
implements PushContext {
    private final String channel;
    private final BeanManager beanManager;
    private final WebsocketScopeManager scopeManager;
    private final WebsocketSessionManager sessionManager;

    public PushContextImpl(String channel, BeanManager beanManager) {
        this.channel = channel;
        this.beanManager = beanManager;
        this.scopeManager = CDIUtils.get(beanManager, WebsocketScopeManager.class);
        this.sessionManager = CDIUtils.get(beanManager, WebsocketSessionManager.class);
    }

    public Set<Future<Void>> send(Object message) {
        List<String> channelTokens;
        WebsocketScopeManager.ApplicationScope applicationScope = this.scopeManager.getApplicationScope(false);
        WebsocketScopeManager.AbstractScope viewScope = null;
        WebsocketScopeManager.SessionScope sessionScope = null;
        if (CDIUtils.isRequestScopeActive(this.beanManager) && CDIUtils.isSessionScopeActive(this.beanManager)) {
            sessionScope = this.scopeManager.getSessionScope(false);
            if (CDIUtils.isViewScopeActive(this.beanManager)) {
                viewScope = this.scopeManager.getViewScope(false);
            }
        }
        if (applicationScope == null) {
            return Collections.emptySet();
        }
        if (viewScope != null && viewScope.isChannelAvailable(this.channel)) {
            channelTokens = viewScope.getChannelTokens(this.channel);
        } else if (sessionScope != null && sessionScope.isChannelAvailable(this.channel)) {
            channelTokens = sessionScope.getChannelTokens(this.channel);
        } else if (applicationScope.isChannelAvailable(this.channel)) {
            channelTokens = applicationScope.getChannelTokens(this.channel);
        } else {
            throw new FacesException("CDI bean not found for push message");
        }
        if (channelTokens != null && !channelTokens.isEmpty()) {
            Set<Future<Void>> result = null;
            for (String channelToken : channelTokens) {
                if (result == null) {
                    result = this.sessionManager.send(channelToken, message);
                    continue;
                }
                result.addAll(this.sessionManager.send(channelToken, message));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public <S extends Serializable> Set<Future<Void>> send(Object message, S user) {
        return this.send(message, Collections.singleton(user)).get(user);
    }

    public <S extends Serializable> Map<S, Set<Future<Void>>> send(Object message, Collection<S> users) {
        HashMap resultsByUser = new HashMap(users.size());
        for (Serializable user : users) {
            Set<String> channelTokenSet = this.sessionManager.getChannelTokensForUser(user, this.channel);
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(channelTokenSet.size());
            for (String channelToken : channelTokenSet) {
                results.addAll(this.sessionManager.send(channelToken, message));
            }
            resultsByUser.put(user, results);
        }
        return resultsByUser;
    }

    private Set<Future<Void>> send(List<String> channelTokens, Object message) {
        if (channelTokens != null && !channelTokens.isEmpty()) {
            Set<Future<Void>> result = null;
            for (int i = 0; i < channelTokens.size(); ++i) {
                String channelToken = channelTokens.get(i);
                if (result == null) {
                    result = this.sessionManager.send(channelToken, message);
                    continue;
                }
                result.addAll(this.sessionManager.send(channelToken, message));
            }
            return result;
        }
        return Collections.emptySet();
    }
}

