/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FacesMessage
implements Serializable {
    private static final long serialVersionUID = 4851488727794169661L;
    public static final String FACES_MESSAGES = "javax.faces.Messages";
    public static final Severity SEVERITY_INFO = new Severity("Info", 1);
    public static final Severity SEVERITY_WARN = new Severity("Warn", 2);
    public static final Severity SEVERITY_ERROR = new Severity("Error", 3);
    public static final Severity SEVERITY_FATAL = new Severity("Fatal", 4);
    public static final List VALUES;
    public static final Map VALUES_MAP;
    private transient Severity _severity;
    private String _summary;
    private String _detail;
    private boolean _rendered;

    public FacesMessage() {
        this._severity = SEVERITY_INFO;
        this._rendered = false;
    }

    public FacesMessage(String summary) {
        this._summary = summary;
        this._severity = SEVERITY_INFO;
        this._rendered = false;
    }

    public FacesMessage(String summary, String detail) {
        this._summary = summary;
        this._detail = detail;
        this._severity = SEVERITY_INFO;
        this._rendered = false;
    }

    public FacesMessage(Severity severity, String summary, String detail) {
        if (severity == null) {
            throw new NullPointerException("severity");
        }
        this._severity = severity;
        this._summary = summary;
        this._detail = detail;
        this._rendered = false;
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public void setSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException("severity");
        }
        this._severity = severity;
    }

    public String getSummary() {
        return this._summary;
    }

    public void setSummary(String summary) {
        this._summary = summary;
    }

    public String getDetail() {
        if (this._detail == null) {
            return this._summary;
        }
        return this._detail;
    }

    public void setDetail(String detail) {
        this._detail = detail;
    }

    public boolean isRendered() {
        return this._rendered;
    }

    public void rendered() {
        this._rendered = true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._severity._ordinal);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int severityOrdinal = in.readInt();
        this._severity = (Severity)VALUES.get(severityOrdinal - 1);
    }

    static {
        HashMap<String, Severity> map = new HashMap<String, Severity>(7);
        map.put(SEVERITY_INFO.toString(), SEVERITY_INFO);
        map.put(SEVERITY_WARN.toString(), SEVERITY_WARN);
        map.put(SEVERITY_ERROR.toString(), SEVERITY_ERROR);
        map.put(SEVERITY_FATAL.toString(), SEVERITY_FATAL);
        VALUES_MAP = Collections.unmodifiableMap(map);
        ArrayList severityList = new ArrayList(map.values());
        Collections.sort(severityList);
        VALUES = Collections.unmodifiableList(severityList);
    }

    public static class Severity
    implements Comparable {
        private String _name;
        private int _ordinal;

        private Severity(String name, int ordinal) {
            this._name = name;
            this._ordinal = ordinal;
        }

        public int getOrdinal() {
            return this._ordinal;
        }

        public String toString() {
            return this._name;
        }

        public int compareTo(Object o) {
            return this.getOrdinal() - ((Severity)o).getOrdinal();
        }
    }
}

