/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.commons.converter.EnumConverter;
import org.apache.myfaces.commons.util.ClassUtils;

public class ConvertEnumTagHandler
extends ConverterHandler {
    private final TagAttribute targetClass = this.getAttribute("targetClass");

    public ConvertEnumTagHandler(ConverterConfig config) {
        super(config);
    }

    public void setAttributes(FaceletContext ctx, Object obj) {
        super.setAttributes(ctx, obj);
        EnumConverter c = (EnumConverter)obj;
        if (this.targetClass != null) {
            if (this.targetClass.isLiteral()) {
                try {
                    c.setTargetClass(ClassUtils.classForName((String)this.targetClass.getValue()));
                }
                catch (ClassNotFoundException e) {
                    throw new TagAttributeException(this.targetClass, "Cannot find class assigned: " + this.targetClass.getValue(), (Throwable)e);
                }
            } else {
                c.setTargetClass((Class)this.targetClass.getObject(ctx, Class.class));
            }
        }
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return super.createMetaRuleset(type).ignore("targetClass");
    }
}

