/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.JQOM2LuceneQueryBuilder;
import org.apache.jackrabbit.core.query.lucene.QueryResultImpl;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.lucene.search.Query;

public class QueryObjectModelImpl
extends AbstractQueryImpl {
    private final QueryObjectModelTree qomTree;

    public QueryObjectModelImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, QueryObjectModelTree qomTree) {
        super(session, itemMgr, index, propReg);
        this.qomTree = qomTree;
        this.extractBindVariableNames();
    }

    public boolean needsSystemTree() {
        return true;
    }

    public Name[] getSelectorNames() {
        SelectorImpl[] selectors = this.qomTree.getSource().getSelectors();
        Name[] names = new Name[selectors.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = selectors[i].getSelectorQName();
        }
        return names;
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        Query query = JQOM2LuceneQueryBuilder.createQuery(this.qomTree, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.getBindVariableValues(), this.index.getIndexFormatVersion());
        ColumnImpl[] columns = this.qomTree.getColumns();
        Name[] selectProps = new Name[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            selectProps[i] = columns[i].getPropertyQName();
        }
        OrderingImpl[] orderings = this.qomTree.getOrderings();
        Name[] orderProps = new Name[orderings.length];
        boolean[] orderSpecs = new boolean[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            orderSpecs[i] = orderings[i].getOrder() == 301;
        }
        return new QueryResultImpl(this.index, this.itemMgr, this.session, this.session.getAccessManager(), this, query, null, selectProps, orderProps, orderSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    private void extractBindVariableNames() {
        try {
            this.qomTree.accept((QOMTreeVisitor)new DefaultTraversingQOMTreeVisitor(){

                public Object visit(BindVariableValueImpl node, Object data) {
                    QueryObjectModelImpl.this.addVariableName(node.getBindVariableQName());
                    return data;
                }
            }, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

