/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.roster;

import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;

public class RosterSubscriptionMutator {
    private static RosterSubscriptionMutator SINGLETON = new RosterSubscriptionMutator();

    public static RosterSubscriptionMutator getInstance() {
        return SINGLETON;
    }

    protected RosterSubscriptionMutator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result add(RosterItem item, AskSubscriptionType addAskSubscriptionType) {
        RosterItem rosterItem = item;
        synchronized (rosterItem) {
            return this.addWorker(item, addAskSubscriptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result add(RosterItem item, SubscriptionType addSubscriptionType) {
        RosterItem rosterItem = item;
        synchronized (rosterItem) {
            return this.addWorker(item, addSubscriptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result remove(RosterItem item, SubscriptionType removeSubscriptionType) {
        RosterItem rosterItem = item;
        synchronized (rosterItem) {
            return this.removeWorker(item, removeSubscriptionType);
        }
    }

    protected Result addWorker(RosterItem item, SubscriptionType addSubscriptionType) {
        switch (addSubscriptionType) {
            case NONE: 
            case BOTH: 
            case REMOVE: {
                return Result.ILLEGAL_ARGUMENT;
            }
            case FROM: {
                return this.addFrom(item);
            }
            case TO: {
                return this.addTo(item);
            }
        }
        throw new IllegalArgumentException("unhandled SubscriptionType " + addSubscriptionType.value());
    }

    protected Result addWorker(RosterItem item, AskSubscriptionType addAskSubscriptionType) {
        switch (addAskSubscriptionType) {
            case NOT_SET: {
                return Result.ILLEGAL_ARGUMENT;
            }
            case ASK_SUBSCRIBE: {
                return this.addAskSubscribe(item);
            }
            case ASK_SUBSCRIBED: {
                return this.addAskSubscribed(item);
            }
        }
        throw new IllegalArgumentException("unhandled SubscriptionType " + addAskSubscriptionType.value());
    }

    protected Result addAskSubscribe(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        AskSubscriptionType typeAsk = item.getAskSubscriptionType();
        if (type.includesTo()) {
            return Result.ALREADY_SET;
        }
        if (typeAsk == AskSubscriptionType.ASK_SUBSCRIBE) {
            return Result.OK;
        }
        item.setAskSubscriptionType(AskSubscriptionType.ASK_SUBSCRIBE);
        return Result.OK;
    }

    protected Result addAskSubscribed(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        AskSubscriptionType typeAsk = item.getAskSubscriptionType();
        if (type.includesFrom()) {
            return Result.ALREADY_SET;
        }
        if (typeAsk == AskSubscriptionType.ASK_SUBSCRIBE) {
            return Result.FAILED;
        }
        if (typeAsk == AskSubscriptionType.ASK_SUBSCRIBED) {
            return Result.OK;
        }
        item.setAskSubscriptionType(AskSubscriptionType.ASK_SUBSCRIBED);
        return Result.OK;
    }

    protected Result addTo(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        if (type.includesTo()) {
            return Result.ALREADY_SET;
        }
        if (type == SubscriptionType.NONE) {
            type = SubscriptionType.TO;
        } else if (type == SubscriptionType.FROM) {
            type = SubscriptionType.BOTH;
        }
        item.setSubscriptionType(type);
        if (item.getAskSubscriptionType() == AskSubscriptionType.ASK_SUBSCRIBE) {
            item.setAskSubscriptionType(AskSubscriptionType.NOT_SET);
        }
        return Result.OK;
    }

    protected Result addFrom(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        if (type.includesFrom()) {
            return Result.ALREADY_SET;
        }
        if (type == SubscriptionType.NONE) {
            type = SubscriptionType.FROM;
        } else if (type == SubscriptionType.TO) {
            type = SubscriptionType.BOTH;
        }
        item.setSubscriptionType(type);
        if (item.getAskSubscriptionType() == AskSubscriptionType.ASK_SUBSCRIBED) {
            item.setAskSubscriptionType(AskSubscriptionType.NOT_SET);
        }
        return Result.OK;
    }

    protected Result removeWorker(RosterItem item, SubscriptionType removeSubscriptionType) {
        switch (removeSubscriptionType) {
            case NONE: 
            case BOTH: 
            case REMOVE: {
                return Result.ILLEGAL_ARGUMENT;
            }
            case FROM: {
                return this.removeFrom(item);
            }
            case TO: {
                return this.removeTo(item);
            }
        }
        throw new IllegalArgumentException("unhandled SubscriptionType " + removeSubscriptionType.value());
    }

    protected Result removeTo(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        if (!type.includesTo()) {
            AskSubscriptionType askType = item.getAskSubscriptionType();
            if (askType != AskSubscriptionType.ASK_SUBSCRIBE) {
                return Result.ALREADY_SET;
            }
            item.setAskSubscriptionType(AskSubscriptionType.NOT_SET);
            return Result.OK;
        }
        if (type == SubscriptionType.BOTH) {
            type = SubscriptionType.FROM;
        } else if (type == SubscriptionType.TO) {
            type = SubscriptionType.NONE;
        }
        item.setSubscriptionType(type);
        return Result.OK;
    }

    protected Result removeFrom(RosterItem item) {
        SubscriptionType type = item.getSubscriptionType();
        if (!type.includesFrom()) {
            AskSubscriptionType askType = item.getAskSubscriptionType();
            if (askType != AskSubscriptionType.ASK_SUBSCRIBED) {
                return Result.ALREADY_SET;
            }
            item.setAskSubscriptionType(AskSubscriptionType.NOT_SET);
            return Result.OK;
        }
        if (type == SubscriptionType.BOTH) {
            type = SubscriptionType.TO;
        } else if (type == SubscriptionType.FROM) {
            type = SubscriptionType.NONE;
        }
        item.setSubscriptionType(type);
        return Result.OK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        OK,
        ILLEGAL_ARGUMENT,
        ALREADY_SET,
        FAILED;

    }
}

