/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;

public class DateTimeProfile {
    protected static final TimeZone TIME_ZONE_UTC;
    protected static final FastDateFormat utcDateFormatter;
    protected static final FastDateFormat utcDateTimeFormatter;
    protected static final FastDateFormat utcTimeFormatter;
    private static final String DATE_PATTERN_VALUE = "(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)";
    private static final String TIME_PATTERN_VALUE = "(\\d\\d):(\\d\\d):(\\d\\d)";
    private static final String TZ_PATTERN_VALUE = "(([+-]\\d\\d:\\d\\d)|Z)";
    private static final Pattern DATE_TIME_PATTERN;
    private static final Pattern DATE_PATTERN;
    private static final Pattern TIME_PATTERN;
    private static final DateTimeProfile SINGLETON;

    public static DateTimeProfile getInstance() {
        return SINGLETON;
    }

    protected DateTimeProfile() {
    }

    public String getDateTimeInUTC(Date time) {
        return utcDateTimeFormatter.format(time);
    }

    public String getDateInUTC(Date time) {
        return utcDateFormatter.format(time);
    }

    public String getTimeInUTC(Date time) {
        return utcTimeFormatter.format(time);
    }

    public Calendar fromDateTime(String time) {
        Matcher matcher = DATE_TIME_PATTERN.matcher(time);
        if (matcher.find()) {
            int year = Integer.valueOf(matcher.group(1));
            int month = Integer.valueOf(matcher.group(2));
            int day = Integer.valueOf(matcher.group(3));
            int hour = Integer.valueOf(matcher.group(4));
            int minute = Integer.valueOf(matcher.group(5));
            int second = Integer.valueOf(matcher.group(6));
            String tzValue = matcher.group(7);
            TimeZone tz = tzValue.equals("Z") ? TIME_ZONE_UTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(year, month - 1, day, hour, minute, second);
            return calendar;
        }
        throw new IllegalArgumentException("Invalid date time: " + time);
    }

    public Calendar fromTime(String time) {
        Matcher matcher = TIME_PATTERN.matcher(time);
        if (matcher.find()) {
            int hour = Integer.valueOf(matcher.group(1));
            int minute = Integer.valueOf(matcher.group(2));
            int second = Integer.valueOf(matcher.group(3));
            String tzValue = matcher.group(4);
            TimeZone tz = tzValue == null || tzValue.equals("Z") ? TIME_ZONE_UTC : TimeZone.getTimeZone("GMT" + tzValue);
            Calendar calendar = Calendar.getInstance(tz);
            calendar.clear();
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            return calendar;
        }
        throw new IllegalArgumentException("Invalid date time: " + time);
    }

    public Calendar fromDate(String time) {
        Matcher matcher = DATE_PATTERN.matcher(time);
        if (matcher.find()) {
            int year = Integer.valueOf(matcher.group(1));
            int month = Integer.valueOf(matcher.group(2));
            int day = Integer.valueOf(matcher.group(3));
            Calendar calendar = Calendar.getInstance(TIME_ZONE_UTC);
            calendar.clear();
            calendar.set(year, month - 1, day);
            return calendar;
        }
        throw new IllegalArgumentException("Invalid date time: " + time);
    }

    static {
        DATE_TIME_PATTERN = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(([+-]\\d\\d:\\d\\d)|Z)$");
        DATE_PATTERN = Pattern.compile("^(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)$");
        TIME_PATTERN = Pattern.compile("^(\\d\\d):(\\d\\d):(\\d\\d)(([+-]\\d\\d:\\d\\d)|Z)?$");
        TIME_ZONE_UTC = TimeZone.getTimeZone("UTC");
        utcDateTimeFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)TIME_ZONE_UTC);
        utcDateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)TIME_ZONE_UTC);
        utcTimeFormatter = FastDateFormat.getInstance((String)"HH:mm:ss'Z'", (TimeZone)TIME_ZONE_UTC);
        SINGLETON = new DateTimeProfile();
    }
}

