/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.model;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RoomType {
    FullyAnonymous(null),
    Hidden("muc_hidden"),
    MembersOnly("muc_membersonly"),
    Moderated("muc_moderated"),
    NonAnonymous("muc_nonanonymous"),
    Open("muc_open"),
    PasswordProtected("muc_passwordprotected"),
    Persistent("muc_persistent"),
    Public("muc_public"),
    SemiAnonymous("muc_semianonymous"),
    Temporary("muc_temporary"),
    Unmoderated("muc_unmoderated"),
    Unsecured("muc_unsecured"),
    OpenSubject(null);

    private String discoName;

    private RoomType(String mucName) {
        this.discoName = mucName;
    }

    public String getDiscoName() {
        return this.discoName;
    }

    private static void complement(EnumSet<RoomType> types, RoomType defaultType, RoomType ... antonyms) {
        if (types.contains((Object)defaultType)) {
            return;
        }
        for (RoomType type : antonyms) {
            if (!types.contains((Object)type)) continue;
            return;
        }
        types.add(defaultType);
    }

    public static EnumSet<RoomType> complement(EnumSet<RoomType> in) {
        EnumSet<RoomType> result = EnumSet.copyOf(in);
        RoomType.complement(result, Public, Hidden);
        RoomType.complement(result, Open, MembersOnly);
        RoomType.complement(result, Temporary, Persistent);
        RoomType.complement(result, Unmoderated, Moderated);
        RoomType.complement(result, Unsecured, PasswordProtected);
        RoomType.complement(result, NonAnonymous, SemiAnonymous, FullyAnonymous);
        return result;
    }

    public static void validateAntonyms(EnumSet<RoomType> types) {
        if (types.contains((Object)Hidden) && types.contains((Object)Public)) {
            throw new IllegalArgumentException("Room can not be both Hidden and Public");
        }
        if (types.contains((Object)MembersOnly) && types.contains((Object)Open)) {
            throw new IllegalArgumentException("Room can not be both MembersOnly and Open");
        }
        if (types.contains((Object)Temporary) && types.contains((Object)Persistent)) {
            throw new IllegalArgumentException("Room can not be both Temporary and Persistent");
        }
        if (types.contains((Object)Unmoderated) && types.contains((Object)Moderated)) {
            throw new IllegalArgumentException("Room can not be both Unmoderated and Moderated");
        }
        if (types.contains((Object)Unsecured) && types.contains((Object)PasswordProtected)) {
            throw new IllegalArgumentException("Room can not be both Unsecured and PasswordProtected");
        }
        if (types.contains((Object)NonAnonymous) && types.contains((Object)SemiAnonymous)) {
            throw new IllegalArgumentException("Room can not be both NonAnonymous and SemiAnonymous");
        }
        if (types.contains((Object)SemiAnonymous) && types.contains((Object)FullyAnonymous)) {
            throw new IllegalArgumentException("Room can not be both FullyAnonymous and SemiAnonymous");
        }
        if (types.contains((Object)NonAnonymous) && types.contains((Object)FullyAnonymous)) {
            throw new IllegalArgumentException("Room can not be both NonAnonymous and FullyAnonymous");
        }
    }

    public boolean includeInDisco() {
        return this.discoName != null;
    }
}

