/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingIndexReader
extends FilterIndexReader {
    private static final Logger log = LoggerFactory.getLogger((Class)CachingIndexReader.class);
    private static long currentTick;
    private final DocId[] parents;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    static final TermDocs EMPTY;

    CachingIndexReader(IndexReader delegatee, DocNumberCache cache) throws IOException {
        super(delegatee);
        this.cache = cache;
        this.parents = new DocId[delegatee.maxDoc()];
        this.initializeParents(delegatee);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        DocId parent = this.parents[n];
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug(parent + " not valid anymore.");
                }
                parent = null;
            }
        }
        if (parent == null) {
            Document doc = this.document(n, FieldSelectors.UUID_AND_PARENT);
            String parentUUID = doc.get(FieldNames.PARENT);
            if (parentUUID == null || parentUUID.length() == 0) {
                parent = DocId.NULL;
            } else {
                if (!existing) {
                    Term id = new Term(FieldNames.UUID, parentUUID);
                    TermDocs docs = this.termDocs(id);
                    try {
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            parent = DocId.create(docs.doc());
                            break;
                        }
                    }
                    finally {
                        docs.close();
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUID);
                }
            }
            this.parents[n] = parent;
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID && this.cache != null) {
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && e.creationTick == this.creationTick && !this.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc);
            }
            TermDocs docs = this.in.termDocs(term);
            try {
                if (docs.next()) {
                    this.cache.put(term.text(), this, docs.doc());
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc());
                    return singleTermDocs;
                }
                TermDocs termDocs = EMPTY;
                return termDocs;
            }
            finally {
                docs.close();
            }
        }
        return super.termDocs(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class clazz = CachingIndexReader.class;
        synchronized (clazz) {
            return currentTick++;
        }
    }

    private void initializeParents(IndexReader reader) throws IOException {
        long time = System.currentTimeMillis();
        HashMap<UUID, NodeInfo> docs = new HashMap<UUID, NodeInfo>();
        for (int i = 0; i < reader.maxDoc(); ++i) {
            if (reader.isDeleted(i)) continue;
            Document doc = reader.document(i, FieldSelectors.UUID_AND_PARENT);
            UUID uuid = UUID.fromString((String)doc.get(FieldNames.UUID));
            UUID parent = null;
            try {
                parent = UUID.fromString((String)doc.get(FieldNames.PARENT));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            NodeInfo info = new NodeInfo(i, uuid, parent);
            docs.put(uuid, info);
        }
        double foreignParents = 0.0;
        Iterator it = docs.values().iterator();
        while (it.hasNext()) {
            NodeInfo info = (NodeInfo)it.next();
            NodeInfo parent = (NodeInfo)docs.get(info.parent);
            if (parent != null) {
                this.parents[info.docId] = DocId.create(parent.docId);
                continue;
            }
            if (info.parent != null) {
                foreignParents += 1.0;
                this.parents[info.docId] = DocId.create(info.parent);
                continue;
            }
            this.parents[info.docId] = DocId.NULL;
        }
        if (log.isDebugEnabled()) {
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMaximumFractionDigits(1);
            time = System.currentTimeMillis() - time;
            if (this.parents.length > 0) {
                foreignParents /= (double)this.parents.length;
            }
            log.debug("initialized {} DocIds in {} ms, {} foreign parents", new Object[]{new Integer(this.parents.length), new Long(time), nf.format(foreignParents)});
        }
    }

    static {
        EMPTY = new TermDocs(){

            public void seek(Term term) {
            }

            public void seek(TermEnum termEnum) {
            }

            public int doc() {
                return -1;
            }

            public int freq() {
                return -1;
            }

            public boolean next() {
                return false;
            }

            public int read(int[] docs, int[] freqs) {
                return 0;
            }

            public boolean skipTo(int target) {
                return false;
            }

            public void close() {
            }
        };
    }

    private static class NodeInfo {
        final int docId;
        final UUID uuid;
        final UUID parent;

        public NodeInfo(int docId, UUID uuid, UUID parent) {
            this.docId = docId;
            this.uuid = uuid;
            this.parent = parent;
        }
    }
}

