/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.authorization.Plain;
import org.apache.vysper.xmpp.authorization.SASLMechanism;
import org.apache.vysper.xmpp.cryptography.BogusTrustManagerFactory;
import org.apache.vysper.xmpp.cryptography.InputStreamBasedTLSContextFactory;
import org.apache.vysper.xmpp.delivery.OfflineStanzaReceiver;
import org.apache.vysper.xmpp.delivery.StanzaRelayBroker;
import org.apache.vysper.xmpp.delivery.inbound.DeliveringExternalInboundStanzaRelay;
import org.apache.vysper.xmpp.delivery.inbound.DeliveringInternalInboundStanzaRelay;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.modules.core.base.BaseStreamStanzaDictionary;
import org.apache.vysper.xmpp.modules.core.bind.BindResourceDictionary;
import org.apache.vysper.xmpp.modules.core.compatibility.jabber_iq_auth.JabberIQAuthDictionary;
import org.apache.vysper.xmpp.modules.core.sasl.SASLStanzaDictionary;
import org.apache.vysper.xmpp.modules.core.session.SessionStanzaDictionary;
import org.apache.vysper.xmpp.modules.core.starttls.StartTLSStanzaDictionary;
import org.apache.vysper.xmpp.modules.extension.xep0160_offline_storage.OfflineStorageProvider;
import org.apache.vysper.xmpp.modules.roster.RosterModule;
import org.apache.vysper.xmpp.modules.servicediscovery.ServiceDiscoveryModule;
import org.apache.vysper.xmpp.protocol.HandlerDictionary;
import org.apache.vysper.xmpp.server.DefaultServerRuntimeContext;
import org.apache.vysper.xmpp.server.Endpoint;
import org.apache.vysper.xmpp.server.ServerFeatures;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPServer {
    private final List<SASLMechanism> saslMechanisms = new ArrayList<SASLMechanism>();
    private String serverDomain;
    private DefaultServerRuntimeContext serverRuntimeContext;
    private StorageProviderRegistry storageProviderRegistry;
    private InputStream tlsCertificate;
    private String tlsCertificatePassword;
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    public XMPPServer(String domain) {
        this.serverDomain = domain;
        this.saslMechanisms.add(new Plain());
    }

    public void setSASLMechanisms(List<SASLMechanism> validMechanisms) {
        this.saslMechanisms.addAll(validMechanisms);
    }

    public void setStorageProviderRegistry(StorageProviderRegistry storageProviderRegistry) {
        this.storageProviderRegistry = storageProviderRegistry;
    }

    public void setTLSCertificateInfo(File certificate, String password) throws FileNotFoundException {
        this.tlsCertificate = new FileInputStream(certificate);
        this.tlsCertificatePassword = password;
    }

    public void setTLSCertificateInfo(InputStream certificate, String password) {
        this.tlsCertificate = certificate;
        this.tlsCertificatePassword = password;
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public void start() throws Exception {
        BogusTrustManagerFactory bogusTrustManagerFactory = new BogusTrustManagerFactory();
        InputStreamBasedTLSContextFactory tlsContextFactory = new InputStreamBasedTLSContextFactory(this.tlsCertificate);
        tlsContextFactory.setPassword(this.tlsCertificatePassword);
        tlsContextFactory.setTrustManagerFactory(bogusTrustManagerFactory);
        ArrayList<HandlerDictionary> dictionaries = new ArrayList<HandlerDictionary>();
        this.addCoreDictionaries(dictionaries);
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        EntityImpl serverEntity = new EntityImpl(null, this.serverDomain, null);
        AccountManagement accountManagement = (AccountManagement)this.storageProviderRegistry.retrieve(AccountManagement.class);
        OfflineStanzaReceiver offlineReceiver = (OfflineStanzaReceiver)((Object)this.storageProviderRegistry.retrieve(OfflineStorageProvider.class));
        DeliveringInternalInboundStanzaRelay internalStanzaRelay = new DeliveringInternalInboundStanzaRelay(serverEntity, resourceRegistry, accountManagement, offlineReceiver);
        DeliveringExternalInboundStanzaRelay externalStanzaRelay = new DeliveringExternalInboundStanzaRelay();
        StanzaRelayBroker stanzaRelayBroker = new StanzaRelayBroker();
        stanzaRelayBroker.setInternalRelay(internalStanzaRelay);
        stanzaRelayBroker.setExternalRelay(externalStanzaRelay);
        ServerFeatures serverFeatures = new ServerFeatures();
        serverFeatures.setAuthenticationMethods(this.saslMechanisms);
        this.serverRuntimeContext = new DefaultServerRuntimeContext(serverEntity, stanzaRelayBroker, serverFeatures, dictionaries, resourceRegistry);
        this.serverRuntimeContext.setStorageProviderRegistry(this.storageProviderRegistry);
        this.serverRuntimeContext.setTlsContextFactory(tlsContextFactory);
        this.serverRuntimeContext.addModule(new ServiceDiscoveryModule());
        this.serverRuntimeContext.addModule(new RosterModule());
        stanzaRelayBroker.setServerRuntimeContext(this.serverRuntimeContext);
        internalStanzaRelay.setServerRuntimeContext(this.serverRuntimeContext);
        externalStanzaRelay.setServerRuntimeContext(this.serverRuntimeContext);
        if (this.endpoints.size() == 0) {
            throw new IllegalStateException("server must have at least one endpoint");
        }
        for (Endpoint endpoint : this.endpoints) {
            endpoint.setServerRuntimeContext(this.serverRuntimeContext);
            endpoint.start();
        }
    }

    public void stop() {
        for (Endpoint endpoint : this.endpoints) {
            endpoint.stop();
        }
        this.serverRuntimeContext.getServerConnectorRegistry().close();
    }

    public void addModule(Module module) {
        this.serverRuntimeContext.addModule(module);
    }

    private void addCoreDictionaries(List<HandlerDictionary> dictionaries) {
        dictionaries.add(new BaseStreamStanzaDictionary());
        dictionaries.add(new StartTLSStanzaDictionary());
        dictionaries.add(new SASLStanzaDictionary());
        dictionaries.add(new BindResourceDictionary());
        dictionaries.add(new SessionStanzaDictionary());
        dictionaries.add(new JabberIQAuthDictionary());
    }

    public ServerRuntimeContext getServerRuntimeContext() {
        return this.serverRuntimeContext;
    }
}

