/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.im.handler;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.failure.DeliveryException;
import org.apache.vysper.xmpp.delivery.failure.IgnoreFailureStrategy;
import org.apache.vysper.xmpp.modules.roster.persistence.RosterManager;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.PresenceStanza;
import org.apache.vysper.xmpp.stanza.PresenceStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPresenceSpecializedHandler {
    final Logger logger = LoggerFactory.getLogger(AbstractPresenceSpecializedHandler.class);

    protected PresenceStanza buildPresenceStanza(Entity from, Entity to, PresenceStanzaType type, List<XMLElement> innerElements) {
        StanzaBuilder builder = StanzaBuilder.createPresenceStanza(from, to, null, type, null, null);
        if (innerElements != null) {
            for (XMLElement innerElement : innerElements) {
                builder.addPreparedElement(innerElement);
            }
        }
        return (PresenceStanza)XMPPCoreStanza.getWrapper((Stanza)builder.build());
    }

    protected void relayStanza(Entity receiver, Stanza stanza, SessionContext sessionContext) {
        try {
            sessionContext.getServerRuntimeContext().getStanzaRelay().relay(receiver, stanza, new IgnoreFailureStrategy());
        }
        catch (DeliveryException e) {
            this.logger.warn("presence relaying failed ", (Throwable)e);
        }
    }

    abstract Stanza executeCorePresence(ServerRuntimeContext var1, boolean var2, SessionContext var3, PresenceStanza var4, RosterManager var5);
}

