/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.vysper.xmpp.extension.xep0124.BoshDecoder;
import org.apache.vysper.xmpp.extension.xep0124.BoshHandler;
import org.apache.vysper.xmpp.extension.xep0124.BoshResponse;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoshServlet
extends HttpServlet {
    public static final String TXT_CONTENT_TYPE = "text/plain";
    public static final String HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
    public static final String XML_CONTENT_TYPE = "text/xml; charset=UTF-8";
    private static final long serialVersionUID = 1979722775762481476L;
    private static final String FLASH_CROSS_DOMAIN_POLICY_URI = "/crossdomain.xml";
    private static final String INFO_GET = "This is an XMPP BOSH connection manager, only POST is allowed";
    private static final String SERVER_IDENTIFICATION = "Vysper/0.5";
    private final Logger logger = LoggerFactory.getLogger(BoshServlet.class);
    private final BoshHandler boshHandler = new BoshHandler();
    private List<String> accessControlAllowOrigin;
    private String accessControlMaxAge = "86400";
    private String accessControlAllowMethods = "GET, POST, OPTIONS";

    public void setServerRuntimeContext(ServerRuntimeContext serverRuntimeContext) {
        this.boshHandler.setServerRuntimeContext(serverRuntimeContext);
    }

    public List<String> getAccessControlAllowOrigin() {
        return this.accessControlAllowOrigin;
    }

    public void setAccessControlAllowOrigin(List<String> accessControlAllowOrigin) {
        this.accessControlAllowOrigin = accessControlAllowOrigin;
    }

    private byte[] createFlashCrossDomainPolicy() {
        StringBuffer crossDomain = new StringBuffer();
        crossDomain.append("<?xml version='1.0'?>");
        crossDomain.append("<!DOCTYPE cross-domain-policy SYSTEM 'http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd'>");
        crossDomain.append("<cross-domain-policy>");
        for (String domain : this.accessControlAllowOrigin) {
            crossDomain.append("<allow-access-from domain='");
            crossDomain.append(domain);
            crossDomain.append("' />");
        }
        crossDomain.append("</cross-domain-policy>");
        try {
            return crossDomain.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private String createAccessControlAllowOrigin() {
        StringBuffer crossDomain = new StringBuffer();
        boolean first = true;
        for (String domain : this.accessControlAllowOrigin) {
            if (!first) {
                crossDomain.append(',');
            }
            crossDomain.append(domain);
            first = false;
        }
        return crossDomain.toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addDateHeader("Date", System.currentTimeMillis());
        resp.addHeader("Server", SERVER_IDENTIFICATION);
        if (FLASH_CROSS_DOMAIN_POLICY_URI.equals(req.getRequestURI())) {
            if (this.accessControlAllowOrigin != null) {
                resp.setContentType(XML_CONTENT_TYPE);
                byte[] flashCrossDomainPolicy = this.createFlashCrossDomainPolicy();
                resp.setContentLength(flashCrossDomainPolicy.length);
                resp.getOutputStream().write(flashCrossDomainPolicy);
            } else {
                resp.sendError(404);
            }
        } else {
            resp.sendError(405, INFO_GET);
        }
        resp.flushBuffer();
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.addDateHeader("Date", System.currentTimeMillis());
        resp.addHeader("Server", SERVER_IDENTIFICATION);
        resp.setContentType(TXT_CONTENT_TYPE);
        resp.setContentLength(0);
        if (this.accessControlAllowOrigin != null) {
            resp.addHeader("Access-Control-Allow-Origin", this.createAccessControlAllowOrigin());
            resp.addHeader("Access-Control-Allow-Methods", this.accessControlAllowMethods);
            resp.addHeader("Access-Control-Max-Age", this.accessControlMaxAge);
            resp.addHeader("Access-Control-Allow-Headers", "Content-Type, User-Agent, If-Modified-Since, Cache-Control");
        }
        resp.flushBuffer();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BoshResponse boshResponse = (BoshResponse)req.getAttribute("response");
        if (boshResponse != null) {
            this.writeResponse(resp, boshResponse);
            return;
        }
        BoshDecoder decoder = new BoshDecoder(this.boshHandler, req);
        try {
            decoder.decode();
        }
        catch (SAXException e) {
            this.logger.error("Exception thrown while decoding XML", (Throwable)e);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405, INFO_GET);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405, INFO_GET);
    }

    private void writeResponse(HttpServletResponse resp, BoshResponse respData) throws IOException {
        resp.addDateHeader("Date", System.currentTimeMillis());
        resp.addHeader("Server", SERVER_IDENTIFICATION);
        resp.setContentType(respData.getContentType());
        resp.setContentLength(respData.getContent().length);
        if (this.accessControlAllowOrigin != null) {
            resp.addHeader("Access-Control-Allow-Origin", this.createAccessControlAllowOrigin());
        }
        resp.getOutputStream().write(respData.getContent());
        resp.flushBuffer();
    }
}

