/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.drivers.ConnectionProxyFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.util.Messages;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;

public final class JNDIConnectionFactory
extends AbstractConnectionFactory {
    private static final Log LOG = LogFactory.getLog((Class)JNDIConnectionFactory.class);
    private DataSource _dataSource = null;

    public JNDIConnectionFactory(JdoConf jdoConf, int index, Mapping mapping) {
        super(jdoConf, index, mapping);
    }

    protected void initializeFactory() throws MappingException {
        Object dataSource;
        DatabaseChoice dbChoice = this.getDatabase().getDatabaseChoice();
        String name = null;
        try {
            name = dbChoice.getJndi().getName();
            InitialContext initialContext = new InitialContext();
            dataSource = initialContext.lookup(name);
        }
        catch (NameNotFoundException e) {
            String msg = Messages.format("jdo.jndiNameNotFound", name);
            LOG.error((Object)msg, (Throwable)e);
            throw new MappingException(msg, e);
        }
        catch (NamingException e) {
            throw new MappingException(e);
        }
        if (!(dataSource instanceof DataSource)) {
            String msg = Messages.format("jdo.jndiNameNotFound", name);
            LOG.error((Object)msg);
            throw new MappingException(msg);
        }
        this._dataSource = (DataSource)dataSource;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using DataSource from JNDI ENC: " + name));
        }
    }

    public Connection createConnection() throws SQLException {
        return ConnectionProxyFactory.newConnectionProxy(this._dataSource.getConnection(), this.getClass().getName());
    }
}

