/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.search.child.ParentIdCollector;
import org.elasticsearch.index.search.child.ParentIdsFilter;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query {
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final ScoreType scoreType;
    private final Query originalChildQuery;
    private final int shortCircuitParentDocSet;
    private final Filter nonNestedDocsFilter;
    private Query rewrittenChildQuery;
    private IndexReader rewriteIndexReader;

    public ChildrenQuery(String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType, int shortCircuitParentDocSet, Filter nonNestedDocsFilter) {
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.originalChildQuery = childQuery;
        this.scoreType = scoreType;
        this.shortCircuitParentDocSet = shortCircuitParentDocSet;
        this.nonNestedDocsFilter = nonNestedDocsFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ChildrenQuery that = (ChildrenQuery)((Object)obj);
        if (!this.originalChildQuery.equals((Object)that.originalChildQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.childType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChildrenQuery[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field)).append(')').append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenChildQuery == null) {
            this.rewriteIndexReader = reader;
            this.rewrittenChildQuery = this.originalChildQuery.rewrite(reader);
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Filter parentFilter;
        Query childQuery;
        ChildUidCollector collector;
        SearchContext searchContext = SearchContext.current();
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        Recycler.V uidToScore = searchContext.cacheRecycler().objectFloatMap(-1);
        Recycler.V uidToCount = null;
        switch (this.scoreType) {
            case AVG: {
                uidToCount = searchContext.cacheRecycler().objectIntMap(-1);
                collector = new AvgChildUidCollector(this.scoreType, searchContext, this.parentType, uidToScore.v(), uidToCount.v());
                break;
            }
            default: {
                collector = new ChildUidCollector(this.scoreType, searchContext, this.parentType, uidToScore.v());
            }
        }
        if (this.rewrittenChildQuery == null) {
            childQuery = this.rewrittenChildQuery = searcher.rewrite(this.originalChildQuery);
        } else {
            assert (this.rewriteIndexReader == searcher.getIndexReader());
            childQuery = this.rewrittenChildQuery;
        }
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        indexSearcher.search(childQuery, (Collector)collector);
        int size = uidToScore.v().size();
        if (size == 0) {
            uidToScore.release();
            if (uidToCount != null) {
                uidToCount.release();
            }
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        if (size == 1) {
            BytesRef id = ((HashedBytesArray)uidToScore.v().keys().iterator().next().value).toBytesRef();
            if (this.nonNestedDocsFilter != null) {
                List<Filter> filters = Arrays.asList(new TermFilter(new Term("_uid", Uid.createUidAsBytes(this.parentType, id))), this.nonNestedDocsFilter);
                parentFilter = new AndFilter(filters);
            } else {
                parentFilter = new TermFilter(new Term("_uid", Uid.createUidAsBytes(this.parentType, id)));
            }
        } else {
            parentFilter = size <= this.shortCircuitParentDocSet ? new ParentIdsFilter(this.parentType, uidToScore.v().keys, uidToScore.v().allocated, this.nonNestedDocsFilter) : new ApplyAcceptedDocsFilter(this.parentFilter);
        }
        ParentWeight parentWeight = new ParentWeight(this.rewrittenChildQuery.createWeight(searcher), parentFilter, searchContext, size, uidToScore, uidToCount);
        searchContext.addReleasable(parentWeight);
        return parentWeight;
    }

    private static final class AvgChildUidCollector
    extends ChildUidCollector {
        private final ObjectIntOpenHashMap<HashedBytesArray> uidToCount;

        AvgChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, ObjectFloatOpenHashMap<HashedBytesArray> uidToScore, ObjectIntOpenHashMap<HashedBytesArray> uidToCount) {
            super(scoreType, searchContext, childType, uidToScore);
            this.uidToCount = uidToCount;
            assert (scoreType == ScoreType.AVG);
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float currentScore = this.scorer.score();
            this.uidToCount.addTo(parentUid, 1);
            this.uidToScore.addTo(parentUid, currentScore);
        }
    }

    private static class ChildUidCollector
    extends ParentIdCollector {
        protected final ObjectFloatOpenHashMap<HashedBytesArray> uidToScore;
        private final ScoreType scoreType;
        protected Scorer scorer;

        ChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, ObjectFloatOpenHashMap<HashedBytesArray> uidToScore) {
            super(childType, searchContext);
            this.uidToScore = uidToScore;
            this.scoreType = scoreType;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float currentScore = this.scorer.score();
            switch (this.scoreType) {
                case SUM: {
                    this.uidToScore.addTo(parentUid, currentScore);
                    break;
                }
                case MAX: {
                    if (this.uidToScore.containsKey(parentUid)) {
                        float previousScore = this.uidToScore.lget();
                        if (!(currentScore > previousScore)) break;
                        this.uidToScore.lset(currentScore);
                        break;
                    }
                    this.uidToScore.put(parentUid, currentScore);
                    break;
                }
                case AVG: {
                    assert (false) : "AVG has its own collector";
                }
                default: {
                    assert (false) : "Are we missing a score type here? -- " + (Object)((Object)this.scoreType);
                    break;
                }
            }
        }
    }

    private final class ParentWeight
    extends Weight
    implements Releasable {
        private final Weight childWeight;
        private final Filter parentFilter;
        private final SearchContext searchContext;
        private final Recycler.V<ObjectFloatOpenHashMap<HashedBytesArray>> uidToScore;
        private final Recycler.V<ObjectIntOpenHashMap<HashedBytesArray>> uidToCount;
        private int remaining;

        private ParentWeight(Weight childWeight, Filter parentFilter, SearchContext searchContext, int remaining, Recycler.V<ObjectFloatOpenHashMap<HashedBytesArray>> uidToScore, Recycler.V<ObjectIntOpenHashMap<HashedBytesArray>> uidToCount) {
            this.childWeight = childWeight;
            this.parentFilter = parentFilter;
            this.searchContext = searchContext;
            this.remaining = remaining;
            this.uidToScore = uidToScore;
            this.uidToCount = uidToCount;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.childWeight.getValueForNormalization();
            return sum *= ChildrenQuery.this.getBoost() * ChildrenQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet parentsSet = this.parentFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(parentsSet) || this.remaining == 0) {
                return null;
            }
            IdReaderTypeCache idTypeCache = this.searchContext.idCache().reader(context.reader()).type(ChildrenQuery.this.parentType);
            DocIdSetIterator parentsIterator = BitsFilteredDocIdSet.wrap((DocIdSet)parentsSet, (Bits)context.reader().getLiveDocs()).iterator();
            switch (ChildrenQuery.this.scoreType) {
                case AVG: {
                    return new AvgParentScorer(this, idTypeCache, this.uidToScore.v(), this.uidToCount.v(), parentsIterator);
                }
            }
            return new ParentScorer(this, idTypeCache, this.uidToScore.v(), parentsIterator);
        }

        @Override
        public boolean release() throws ElasticsearchException {
            Releasables.release(this.uidToScore, this.uidToCount);
            return true;
        }

        private final class AvgParentScorer
        extends ParentScorer {
            final ObjectIntOpenHashMap<HashedBytesArray> uidToCount;

            AvgParentScorer(Weight weight, IdReaderTypeCache idTypeCache, ObjectFloatOpenHashMap<HashedBytesArray> uidToScore, ObjectIntOpenHashMap<HashedBytesArray> uidToCount, DocIdSetIterator parentsIterator) {
                super(weight, idTypeCache, uidToScore, parentsIterator);
                this.uidToCount = uidToCount;
            }

            @Override
            public int nextDoc() throws IOException {
                HashedBytesArray uid;
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                do {
                    this.currentDocId = this.parentsIterator.nextDoc();
                    if (this.currentDocId != Integer.MAX_VALUE) continue;
                    return this.currentDocId;
                } while (!this.uidToScore.containsKey(uid = this.idTypeCache.idByDoc(this.currentDocId)));
                this.currentScore = this.uidToScore.lget();
                this.currentScore /= (float)this.uidToCount.get(uid);
                ParentWeight.this.remaining--;
                return this.currentDocId;
            }

            @Override
            public int advance(int target) throws IOException {
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.currentDocId = this.parentsIterator.advance(target);
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                HashedBytesArray uid = this.idTypeCache.idByDoc(this.currentDocId);
                if (this.uidToScore.containsKey(uid)) {
                    this.currentScore = this.uidToScore.lget();
                    this.currentScore /= (float)this.uidToCount.get(uid);
                    ParentWeight.this.remaining--;
                    return this.currentDocId;
                }
                return this.nextDoc();
            }
        }

        private class ParentScorer
        extends Scorer {
            final ObjectFloatOpenHashMap<HashedBytesArray> uidToScore;
            final IdReaderTypeCache idTypeCache;
            final DocIdSetIterator parentsIterator;
            int currentDocId;
            float currentScore;

            ParentScorer(Weight weight, IdReaderTypeCache idTypeCache, ObjectFloatOpenHashMap<HashedBytesArray> uidToScore, DocIdSetIterator parentsIterator) {
                super(weight);
                this.currentDocId = -1;
                this.idTypeCache = idTypeCache;
                this.parentsIterator = parentsIterator;
                this.uidToScore = uidToScore;
            }

            public float score() throws IOException {
                return this.currentScore;
            }

            public int freq() throws IOException {
                return 1;
            }

            public int docID() {
                return this.currentDocId;
            }

            public int nextDoc() throws IOException {
                HashedBytesArray uid;
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                do {
                    this.currentDocId = this.parentsIterator.nextDoc();
                    if (this.currentDocId != Integer.MAX_VALUE) continue;
                    return this.currentDocId;
                } while (!this.uidToScore.containsKey(uid = this.idTypeCache.idByDoc(this.currentDocId)));
                this.currentScore = this.uidToScore.lget();
                ParentWeight.this.remaining--;
                return this.currentDocId;
            }

            public int advance(int target) throws IOException {
                if (ParentWeight.this.remaining == 0) {
                    this.currentDocId = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.currentDocId = this.parentsIterator.advance(target);
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                HashedBytesArray uid = this.idTypeCache.idByDoc(this.currentDocId);
                if (this.uidToScore.containsKey(uid)) {
                    this.currentScore = this.uidToScore.lget();
                    ParentWeight.this.remaining--;
                    return this.currentDocId;
                }
                return this.nextDoc();
            }

            public long cost() {
                return this.parentsIterator.cost();
            }
        }
    }
}

