/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class TopChildrenQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<TopChildrenQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String childType;
    private String score;
    private float boost = 1.0f;
    private int factor = -1;
    private int incrementalFactor = -1;
    private String queryName;

    public TopChildrenQueryBuilder(String type, QueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
    }

    public TopChildrenQueryBuilder score(String score) {
        this.score = score;
        return this;
    }

    public TopChildrenQueryBuilder factor(int factor) {
        this.factor = factor;
        return this;
    }

    public TopChildrenQueryBuilder incrementalFactor(int incrementalFactor) {
        this.incrementalFactor = incrementalFactor;
        return this;
    }

    @Override
    public TopChildrenQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public TopChildrenQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("top_children");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("type", this.childType);
        if (this.score != null) {
            builder.field("score", this.score);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.factor != -1) {
            builder.field("factor", this.factor);
        }
        if (this.incrementalFactor != -1) {
            builder.field("incremental_factor", this.incrementalFactor);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

