/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.RegexpFlag;

public class RegexpFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final String regexp;
    private int flags = -1;
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public RegexpFilterBuilder(String name, String regexp) {
        this.name = name;
        this.regexp = regexp;
    }

    public RegexpFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public RegexpFilterBuilder flags(RegexpFlag ... flags) {
        int value = 0;
        if (flags.length == 0) {
            value = RegexpFlag.ALL.value;
        } else {
            for (RegexpFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.flags = value;
        return this;
    }

    public RegexpFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public RegexpFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("regexp");
        if (this.flags < 0) {
            builder.field(this.name, this.regexp);
        } else {
            builder.startObject(this.name).field("value", this.regexp).field("flags_value", this.flags).endObject();
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

