/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.breaker.MemoryCircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.PackedArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class PackedArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData<AtomicNumericFieldData> {
    private final IndexNumericFieldData.NumericType numericType;
    private final CircuitBreakerService breakerService;

    public PackedArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, IndexNumericFieldData.NumericType numericType, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Preconditions.checkNotNull(numericType);
        Preconditions.checkArgument(EnumSet.of(IndexNumericFieldData.NumericType.BYTE, IndexNumericFieldData.NumericType.SHORT, IndexNumericFieldData.NumericType.INT, IndexNumericFieldData.NumericType.LONG).contains((Object)numericType), this.getClass().getSimpleName() + " only supports integer types, not " + (Object)((Object)numericType));
        this.numericType = numericType;
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        PackedArrayAtomicFieldData data = null;
        PackedArrayEstimator estimator = new PackedArrayEstimator(this.breakerService.getBreaker(), this.getNumericType());
        if (terms == null) {
            data = PackedArrayAtomicFieldData.empty(reader.maxDoc());
            estimator.adjustForNoTerms(data.getMemorySizeInBytes());
            return data;
        }
        MonotonicAppendingLongBuffer values = new MonotonicAppendingLongBuffer();
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(-1L, reader.maxDoc(), acceptableTransientOverheadRatio);
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            BytesRef term;
            boolean indexedAsLong;
            BytesRefIterator iter = builder.buildFromTerms(termsEnum);
            assert (!this.getNumericType().isFloatingPoint());
            boolean bl = indexedAsLong = this.getNumericType().requiredBits() > 32;
            while ((term = iter.next()) != null) {
                long value;
                long l = value = indexedAsLong ? NumericUtils.prefixCodedToLong((BytesRef)term) : (long)NumericUtils.prefixCodedToInt((BytesRef)term);
                assert (values.size() == 0L || value > values.get(values.size() - 1L));
                values.add(value);
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                long delta;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long maxValue = 0L;
                long minValue = 0L;
                if (values.size() > 0L) {
                    minValue = values.get(0);
                    maxValue = values.get(values.size() - 1L);
                }
                long missingValue = 0L;
                if (set != null) {
                    if (maxValue - minValue + 1L == values.size()) {
                        if (minValue > Long.MIN_VALUE) {
                            missingValue = --minValue;
                        } else {
                            assert (maxValue != Long.MAX_VALUE);
                            missingValue = ++maxValue;
                        }
                    } else {
                        for (long i = 1L; i < values.size(); ++i) {
                            if (values.get(i) <= values.get(i - 1L) + 1L) continue;
                            missingValue = values.get(i - 1L) + 1L;
                            break;
                        }
                    }
                    missingValue -= minValue;
                }
                int bitsRequired = (delta = maxValue - minValue) < 0L ? 64 : PackedInts.bitsRequired((long)delta);
                float acceptableOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.2f)).floatValue();
                PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits((int)reader.maxDoc(), (int)bitsRequired, (float)acceptableOverheadRatio);
                long singleValuesSize = (long)formatAndBits.format.longCount(1, reader.maxDoc(), formatAndBits.bitsPerValue) * 8L;
                long uniqueValuesSize = values.ramBytesUsed();
                if (uniqueValuesSize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesSize) {
                    data = new PackedArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
                } else {
                    PackedInts.Mutable sValues = PackedInts.getMutable((int)reader.maxDoc(), (int)bitsRequired, (float)acceptableOverheadRatio);
                    if (missingValue != 0L) {
                        sValues.fill(0, sValues.size(), missingValue);
                    }
                    for (int i = 0; i < reader.maxDoc(); ++i) {
                        long ord = ordinals.getOrd(i);
                        if (ord == 0L) continue;
                        sValues.set(i, values.get(ord - 1L) - minValue);
                    }
                    data = set == null ? new PackedArrayAtomicFieldData.Single(sValues, minValue, reader.maxDoc(), ordinals.getNumOrds()) : new PackedArrayAtomicFieldData.SingleSparse(sValues, minValue, reader.maxDoc(), missingValue, ordinals.getNumOrds());
                }
            } else {
                data = new PackedArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
            }
            success = true;
            PackedArrayAtomicFieldData packedArrayAtomicFieldData = data;
            return packedArrayAtomicFieldData;
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.getMemorySizeInBytes());
            }
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new LongValuesComparatorSource(this, missingValue, sortMode);
    }

    public class PackedArrayEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final MemoryCircuitBreaker breaker;
        private final IndexNumericFieldData.NumericType type;

        public PackedArrayEstimator(MemoryCircuitBreaker breaker, IndexNumericFieldData.NumericType type) {
            this.breaker = breaker;
            this.type = type;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            return Math.max(this.type.requiredBits() / 10, 4);
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            return new RamAccountingTermsEnum(this.type.wrapTermsEnum(terms.iterator(null)), this.breaker, this);
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            assert (termsEnum instanceof RamAccountingTermsEnum);
            long estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            this.breaker.addWithoutBreaking(-(estimatedBytes - actualUsed));
        }

        public void adjustForNoTerms(long actualUsed) {
            this.breaker.addWithoutBreaking(actualUsed);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private IndexNumericFieldData.NumericType numericType;

        public Builder setNumericType(IndexNumericFieldData.NumericType numericType) {
            this.numericType = numericType;
            return this;
        }

        @Override
        public IndexFieldData<AtomicNumericFieldData> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new PackedArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, this.numericType, breakerService);
        }
    }
}

