/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.shards;

import java.io.IOException;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ClusterSearchShardsGroup
implements Streamable,
ToXContent {
    private String index;
    private int shardId;
    ShardRouting[] shards;

    ClusterSearchShardsGroup() {
    }

    public ClusterSearchShardsGroup(String index, int shardId, ShardRouting[] shards) {
        this.index = index;
        this.shardId = shardId;
        this.shards = shards;
    }

    public static ClusterSearchShardsGroup readSearchShardsGroupResponse(StreamInput in) throws IOException {
        ClusterSearchShardsGroup response = new ClusterSearchShardsGroup();
        response.readFrom(in);
        return response;
    }

    public String getIndex() {
        return this.index;
    }

    public int getShardId() {
        return this.shardId;
    }

    public ShardRouting[] getShards() {
        return this.shards;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.shards = new ShardRouting[in.readVInt()];
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = ImmutableShardRouting.readShardRoutingEntry(in, this.index, this.shardId);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeVInt(this.shards.length);
        for (ShardRouting shardRouting : this.shards) {
            shardRouting.writeToThin(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (ShardRouting shard : this.getShards()) {
            shard.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

