/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.QueryAnnotation;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.httppart.RequestQueryParams;

public class QueryArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final boolean multi;
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final String name;
    private final String def;
    private final ClassInfo type;

    public static QueryArg create(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        if (AP.has(Query.class, paramInfo, new AnnotationTraversal[0])) {
            return new QueryArg(paramInfo, annotations);
        }
        return null;
    }

    private static Query getMergedQuery(ParameterInfo pi, String paramName) {
        ClassInfo declaringClass = pi.getMethod().getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        Rest restAnnotation = declaringClass.getAnnotations(Rest.class).findFirst().map(AnnotationInfo::inner).orElse(null);
        if (restAnnotation == null) {
            return null;
        }
        Query classLevelQuery = null;
        for (Query q : restAnnotation.queryParams()) {
            String qName = StringUtils.firstNonEmpty(q.name(), q.value());
            if (!paramName.equals(qName)) continue;
            classLevelQuery = q;
            break;
        }
        if (classLevelQuery == null) {
            return null;
        }
        Query paramQuery = AP.find(Query.class, pi, new AnnotationTraversal[0]).stream().findFirst().map(AnnotationInfo::inner).orElse(null);
        if (paramQuery == null) {
            return classLevelQuery;
        }
        return QueryArg.mergeAnnotations(classLevelQuery, paramQuery);
    }

    private static Query mergeAnnotations(Query classLevel, Query paramLevel) {
        return QueryAnnotation.create().name(StringUtils.firstNonEmpty(paramLevel.name(), paramLevel.value(), classLevel.name(), classLevel.value())).value(StringUtils.firstNonEmpty(paramLevel.value(), paramLevel.name(), classLevel.value(), classLevel.name())).def(StringUtils.firstNonEmpty(paramLevel.def(), classLevel.def())).description(paramLevel.description().length > 0 ? paramLevel.description() : classLevel.description()).parser(paramLevel.parser() != HttpPartParser.Void.class ? paramLevel.parser() : classLevel.parser()).serializer(paramLevel.serializer() != HttpPartSerializer.Void.class ? paramLevel.serializer() : classLevel.serializer()).schema(QueryArg.mergeSchemas(classLevel.schema(), paramLevel.schema())).build();
    }

    private static Schema mergeSchemas(Schema classLevel, Schema paramLevel) {
        if (!SchemaAnnotation.empty(paramLevel)) {
            return paramLevel;
        }
        return classLevel;
    }

    protected QueryArg(ParameterInfo pi, AnnotationWorkList annotations) {
        this.name = QueryAnnotation.findName(pi).orElseThrow(() -> new ArgException(pi, "@Query used without name or value", new Object[0]));
        Query mergedQuery = QueryArg.getMergedQuery(pi, this.name);
        this.def = Utils.nn(mergedQuery) && !mergedQuery.def().isEmpty() ? mergedQuery.def() : (String)QueryAnnotation.findDef(pi).orElse(null);
        this.type = pi.getParameterType();
        this.schema = Utils.nn(mergedQuery) ? HttpPartSchema.create(mergedQuery) : HttpPartSchema.create(Query.class, pi);
        Class<? extends HttpPartParser> pp = this.schema.getParser();
        this.partParser = Utils.nn(pp) ? (HttpPartParser)HttpPartParser.creator().type((Class)pp).apply(annotations).create() : null;
        boolean bl = this.multi = this.schema.getCollectionFormat() == HttpPartCollectionFormat.MULTI;
        if (this.multi && !this.type.isCollectionOrArray()) {
            throw new ArgException(pi, "Use of multipart flag on @Query parameter that is not an array or Collection", new Object[0]);
        }
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        RequestQueryParams rh = req.getQueryParams();
        BeanSession bs = req.getBeanSession();
        ClassMeta cm = bs.getClassMeta(this.type.innerType(), new Type[0]);
        if (this.multi) {
            List<Object> c = cm.isArray() ? CollectionUtils.list(new Object[0]) : (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new JsonList());
            rh.getAll(this.name).stream().map(x -> x.parser(ps).schema(this.schema).as(cm.getElementType()).orElse(null)).forEach(x -> c.add(x));
            return cm.isArray() ? CollectionUtils.toArray(c, cm.getElementType().inner()) : c;
        }
        if (cm.isMapOrBean() && StringUtils.isOneOf(this.name, "*", "")) {
            JsonMap m = new JsonMap();
            rh.forEach(e -> m.put(e.getName(), (Object)e.parser(ps).schema(this.schema == null ? null : this.schema.getProperty(e.getName())).as(cm.getValueType()).orElse(null)));
            return req.getBeanSession().convertToType((Object)m, cm);
        }
        return rh.getLast(this.name).parser(ps).schema(this.schema).def(this.def).as(this.type.innerType(), new Type[0]).orElse(null);
    }
}

