/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.ArrayList;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;
import org.apache.juneau.xml.annotation.XmlSchema;

public class XmlClassMeta
extends ExtendedClassMeta {
    private final Namespace namespace;
    private final XmlFormat format;
    private final String childName;

    public XmlClassMeta(ClassMeta<?> cm, XmlMetaProvider mp) {
        super(cm);
        ArrayList<Xml> xmls = CollectionUtils.list(new Xml[0]);
        ArrayList<XmlSchema> schemas = CollectionUtils.list(new XmlSchema[0]);
        if (cm != null) {
            cm.forEachAnnotation(Xml.class, x -> true, x -> xmls.add((Xml)x));
            cm.forEachAnnotation(XmlSchema.class, x -> true, x -> schemas.add((XmlSchema)x));
        }
        this.namespace = XmlUtils.findNamespace(xmls, schemas);
        String _childName = null;
        XmlFormat _format = XmlFormat.DEFAULT;
        for (Xml a : xmls) {
            if (a.format() != XmlFormat.DEFAULT) {
                _format = a.format();
            }
            if (a.childName().isEmpty()) continue;
            _childName = a.childName();
        }
        this.format = _format;
        this.childName = _childName;
    }

    protected XmlFormat getFormat() {
        return this.format;
    }

    protected String getChildName() {
        return this.childName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }
}

