/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public abstract class ConfigApply<T extends Annotation> {
    private final VarResolverSession r;
    private final Class<T> c;

    protected ConfigApply(Class<T> c, VarResolverSession r) {
        this.r = r == null ? VarResolver.DEFAULT.createSession() : r;
        this.c = c;
    }

    public abstract void apply(AnnotationInfo<T> var1, PropertyStoreBuilder var2);

    protected String string(String in) {
        return this.r.resolve(in);
    }

    protected String[] strings(String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = this.r.resolve(in[i]);
        }
        return out;
    }

    protected String[] strings(String in) {
        in = this.r.resolve(in);
        return StringUtils.split(in);
    }

    protected Map<String, String> stringsMap(String[] in, String loc) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String s : this.strings(in)) {
            for (String s2 : StringUtils.split(s, ';')) {
                int i = s2.indexOf(58);
                if (i == -1) {
                    throw new ConfigException("Invalid syntax for key/value pair on annotation @{0}({1}): {2}", this.c.getSimpleName(), loc, s2);
                }
                m.put(s2.substring(0, i).trim(), s2.substring(i + 1).trim());
            }
        }
        return m;
    }

    public boolean bool(String in) {
        return Boolean.parseBoolean(this.r.resolve(in));
    }

    protected int integer(String in, String loc) {
        try {
            return Integer.parseInt(this.r.resolve(in));
        }
        catch (NumberFormatException e) {
            throw new ConfigException("Invalid syntax for integer on annotation @{0}({1}): {2}", this.c.getSimpleName(), loc, in);
        }
    }

    protected Visibility visibility(String in, String loc) {
        try {
            return Visibility.valueOf(this.r.resolve(in));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Invalid syntax for visibility on annotation @{0}({1}): {2}", this.c.getSimpleName(), loc, in);
        }
    }

    protected ObjectMap objectMap(String[] in, String loc) {
        return this.objectMap(StringUtils.joinnl(this.strings(in)), loc);
    }

    protected ObjectMap objectMap(String in, String loc) {
        try {
            if (!StringUtils.isObjectMap(in, true)) {
                in = "{" + in + "}";
            }
            return new ObjectMap(in);
        }
        catch (Exception e) {
            throw new ConfigException("Invalid syntax for Simple-JSON on annotation @{0}({1}): {2}", this.c.getSimpleName(), loc, in);
        }
    }
}

