/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.system.ReferenceQueueConsumer;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.resources.Messages;

abstract class WeakEntry<E>
extends WeakReference<E>
implements Disposable {
    static final int MIN_CAPACITY = 7;
    static final int HASH_MASK = Integer.MAX_VALUE;
    static final long REHASH_DELAY = 4000000000L;
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.util");
    WeakEntry<E> next;
    final int hash;

    WeakEntry(E obj, WeakEntry<E> next, int hash) {
        super(obj, ReferenceQueueConsumer.QUEUE);
        this.next = next;
        this.hash = hash;
    }

    static <E> int count(WeakEntry<E>[] table) {
        int n = 0;
        for (WeakEntry<E> e2 : table) {
            while (e2 != null) {
                ++n;
                e2 = e2.next;
            }
        }
        return n;
    }

    final boolean removeFrom(WeakEntry<E>[] table, int removeAt) {
        WeakEntry<E> prev = null;
        WeakEntry<E> e2 = table[removeAt];
        while (e2 != null) {
            if (e2 == this) {
                if (prev != null) {
                    prev.next = e2.next;
                } else {
                    table[removeAt] = e2.next;
                }
                return true;
            }
            prev = e2;
            e2 = e2.next;
        }
        return false;
    }

    static <E> WeakEntry<E>[] rehash(WeakEntry<E>[] oldTable, int count, String callerMethod) {
        int capacity = Math.max(count * 2, 7);
        if (capacity < 65521) {
            capacity = MathFunctions.nextPrimeNumber(capacity);
        }
        if (capacity == oldTable.length) {
            return oldTable;
        }
        Class<?> entryType = oldTable.getClass().getComponentType();
        WeakEntry[] table = (WeakEntry[])Array.newInstance(entryType, capacity);
        for (WeakEntry<E> next : oldTable) {
            while (next != null) {
                WeakEntry<E> e2 = next;
                next = next.next;
                int index = e2.hash % table.length;
                e2.next = table[index];
                table[index] = e2;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.FINEST, (short)4, oldTable.length, table.length);
            record.setSourceMethodName(callerMethod);
            record.setSourceClassName(entryType.getEnclosingClass().getName());
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        return table;
    }

    static int lowerCapacityThreshold(int capacity) {
        return capacity >>> 2;
    }

    static int upperCapacityThreshold(int capacity) {
        return capacity - (capacity >>> 2);
    }

    static boolean identityEqual(Object o1, Object o2) {
        return o1 == o2;
    }
}

