/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.Prefixes;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;

final class ConventionalUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 6963634855104019466L;
    private final AbstractUnit<Q> target;
    final UnitConverter toTarget;

    ConventionalUnit(AbstractUnit<Q> target, UnitConverter toTarget, String symbol, byte scope, short epsg) {
        super(symbol, scope, epsg);
        this.target = target;
        this.toTarget = toTarget;
    }

    static <Q extends Quantity<Q>> AbstractUnit<Q> create(AbstractUnit<Q> target, UnitConverter toTarget) {
        char prefix;
        double scale;
        String ts;
        if (toTarget.isIdentity()) {
            return target;
        }
        ConventionalUnit<Q>[] related = target.related();
        if (related != null && toTarget instanceof LinearConverter) {
            LinearConverter c = (LinearConverter)toTarget;
            for (ConventionalUnit<Q> existing : related) {
                if (!c.equivalent((LinearConverter)existing.toTarget)) continue;
                return existing;
            }
        }
        String symbol = null;
        if (target.isPrefixable() && (ts = target.getSymbol()) != null && !ts.isEmpty() && !Double.isNaN(scale = AbstractConverter.scale(toTarget)) && (prefix = Prefixes.symbol(scale, ConventionalUnit.power(ts))) != '\u0000') {
            symbol = Prefixes.concat(prefix, ts);
        }
        ConventionalUnit<Q> unit = new ConventionalUnit<Q>(target, toTarget, symbol, 0, 0);
        if (symbol != null) {
            unit = unit.unique(symbol);
        }
        return unit;
    }

    final ConventionalUnit<Q> unique(String symbol) {
        Object existing = UnitRegistry.putIfAbsent(symbol, this);
        if (existing instanceof ConventionalUnit) {
            boolean equivalent;
            ConventionalUnit c = (ConventionalUnit)existing;
            if (this.target.equals(c.target) && (equivalent = this.toTarget instanceof LinearConverter && c.toTarget instanceof LinearConverter ? ((LinearConverter)this.toTarget).equivalent((LinearConverter)c.toTarget) : this.toTarget.equals(c.toTarget))) {
                return c;
            }
        }
        return this;
    }

    private static String pow(String symbol, int n, boolean root2) {
        if (symbol != null) {
            int i;
            int c;
            int length = symbol.length();
            int power = 1;
            for (i = 0; i < length; i += Character.charCount(c)) {
                c = symbol.codePointAt(i);
                if (ConventionalUnit.isSymbolChar(c)) continue;
                if (!Characters.isSuperScript(c) || i + Character.charCount(c) < length) {
                    return null;
                }
                power = Characters.toNormalScript(c) - 48;
            }
            if (power >= 0 && power <= 9) {
                boolean isValid;
                if (root2) {
                    isValid = power % n == 0;
                    power /= n;
                } else {
                    boolean bl = isValid = (power *= n) >= 0 && power <= 9;
                }
                if (isValid) {
                    return symbol.substring(0, i) + Characters.toSuperScript((char)(power + 48));
                }
            }
        }
        return null;
    }

    static int power(String symbol) {
        int c;
        int length = symbol.length();
        int i = 0;
        do {
            if (i >= length) {
                return 1;
            }
            c = symbol.codePointAt(i);
            i += Character.charCount(c);
        } while (ConventionalUnit.isSymbolChar(c));
        int p = Characters.toNormalScript(c) - 48;
        if (p >= 0 && p <= 9) {
            if (i < length) {
                c = symbol.codePointAt(i);
                if (ConventionalUnit.isSymbolChar(c)) {
                    return 0;
                }
                if ((c = Characters.toNormalScript(c)) >= 48 && c <= 57) {
                    return 0;
                }
            }
            return p;
        }
        return 1;
    }

    @Override
    public Dimension getDimension() {
        return this.target.getDimension();
    }

    @Override
    public SystemUnit<Q> getSystemUnit() {
        return this.target.getSystemUnit();
    }

    @Override
    public Map<SystemUnit<?>, Integer> getBaseUnits() {
        return this.target.getBaseUnits();
    }

    @Override
    final Map<SystemUnit<?>, Fraction> getBaseSystemUnits() {
        return this.target.getBaseSystemUnits();
    }

    @Override
    public <T extends Quantity<T>> Unit<T> asType(Class<T> type) throws ClassCastException {
        Unit<T> alternate = this.target.asType(type);
        if (this.target.equals(alternate)) {
            return this;
        }
        return alternate.transform(this.toTarget);
    }

    @Override
    public UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        if (that == this) {
            return IdentityConverter.INSTANCE;
        }
        ArgumentChecks.ensureNonNull("that", that);
        UnitConverter c = this.toTarget;
        if (this.target != that) {
            Unit<Q> step = that.getSystemUnit();
            if (this.target != step && !this.target.isCompatible(step)) {
                throw new UnconvertibleException(this.incompatible(that));
            }
            c = this.target.getConverterTo(step).concatenate(c);
            c = step.getConverterTo(that).concatenate(c);
        }
        return c;
    }

    @Override
    public UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException {
        if (that == this) {
            return IdentityConverter.INSTANCE;
        }
        ArgumentChecks.ensureNonNull("that", that);
        UnitConverter c = this.toTarget;
        if (this.target != that) {
            Unit<?> step = that.getSystemUnit();
            if (this.target != step && !this.target.isCompatible(step)) {
                throw new IncommensurableException(this.incompatible(that));
            }
            c = this.target.getConverterToAny(step).concatenate(c);
            c = step.getConverterToAny(that).concatenate(c);
        }
        return c;
    }

    final ConventionalUnit<Q> forSymbol(String symbol) {
        if (symbol.equals(this.getSymbol())) {
            return this;
        }
        return new ConventionalUnit<Q>(this.target, this.toTarget, symbol, this.scope, this.epsg);
    }

    @Override
    public Unit<Q> alternate(String symbol) {
        throw new MeasurementException(Errors.format((short)106, this));
    }

    private void ensureRatioScale() {
        if (!this.toTarget.isLinear()) {
            throw new IllegalStateException(Errors.format((short)104, this));
        }
    }

    @Override
    public Unit<?> multiply(Unit<?> multiplier) {
        if (multiplier == this) {
            return this.pow(2);
        }
        this.ensureRatioScale();
        return this.inferSymbol(this.target.multiply(multiplier).transform(this.toTarget), '\u22c5', multiplier);
    }

    @Override
    public Unit<?> divide(Unit<?> divisor) {
        this.ensureRatioScale();
        return this.inferSymbol(this.target.divide(divisor).transform(this.toTarget), '\u2215', divisor);
    }

    @Override
    public Unit<?> pow(int n) {
        this.ensureRatioScale();
        return this.inferSymbol(this.applyConversion(this.target.pow(n), n, false), '\u207f', null);
    }

    @Override
    public Unit<?> root(int n) {
        this.ensureRatioScale();
        return this.applyConversion(this.target.root(n), n, true);
    }

    private Unit<?> applyConversion(Unit<?> result, int n, boolean root2) {
        String symbol;
        if (result == this.target) {
            return this;
        }
        LinearConverter operation = LinearConverter.pow(this.toTarget, n, root2);
        if (result instanceof SystemUnit && (symbol = ConventionalUnit.pow(this.getSymbol(), n, root2)) != null) {
            return new ConventionalUnit<Q>((SystemUnit)result, operation, symbol, 0, 0).unique(symbol);
        }
        return result.transform(operation);
    }

    @Override
    public Unit<Q> transform(UnitConverter operation) {
        ArgumentChecks.ensureNonNull("operation", operation);
        AbstractUnit base = this;
        if (!this.isPrefixable()) {
            base = this.target;
            operation = this.toTarget.concatenate(operation);
        }
        return ConventionalUnit.create(base, operation);
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (other == this) {
            return true;
        }
        if (super.equals(other, mode)) {
            ConventionalUnit that = (ConventionalUnit)other;
            return Utilities.deepEquals(this.target, that.target, mode) && Utilities.deepEquals(this.toTarget, that.toTarget, mode);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.target.hashCode() + 31 * this.toTarget.hashCode());
    }
}

