/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.mgt;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.apache.shiro.lang.codec.Base64;
import org.apache.shiro.mgt.AbstractRememberMeManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.subject.WebSubjectContext;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieRememberMeManager
extends AbstractRememberMeManager {
    public static final String DEFAULT_REMEMBER_ME_COOKIE_NAME = "rememberMe";
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieRememberMeManager.class);
    private Cookie cookie;

    public CookieRememberMeManager() {
        this.setCookie(this.createDefaultCookie());
    }

    public CookieRememberMeManager(Supplier<byte[]> keySupplier) {
        super(keySupplier);
        this.setCookie(this.createDefaultCookie());
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public void setCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    @Override
    protected void rememberSerializedIdentity(Subject subject, byte[] serialized) {
        if (!WebUtils.isHttp(subject)) {
            if (LOGGER.isDebugEnabled()) {
                String msg = "Subject argument is not an HTTP-aware instance.  This is required to obtain a servlet request and response in order to set the rememberMe cookie. Returning immediately and ignoring rememberMe operation.";
                LOGGER.debug(msg);
            }
            return;
        }
        HttpServletRequest request = WebUtils.getHttpRequest(subject);
        HttpServletResponse response = WebUtils.getHttpResponse(subject);
        String base64 = Base64.encodeToString(serialized);
        Cookie template = this.getCookie();
        SimpleCookie cookie = new SimpleCookie(template);
        cookie.setValue(base64);
        cookie.saveTo(request, response);
    }

    private boolean isIdentityRemoved(WebSubjectContext subjectContext) {
        ServletRequest request = subjectContext.resolveServletRequest();
        if (request != null) {
            Boolean removed = (Boolean)request.getAttribute(ShiroHttpServletRequest.IDENTITY_REMOVED_KEY);
            return removed != null && removed != false;
        }
        return false;
    }

    @Override
    protected byte[] getRememberedSerializedIdentity(SubjectContext subjectContext) {
        if (!WebUtils.isHttp(subjectContext)) {
            if (LOGGER.isDebugEnabled()) {
                String msg = "SubjectContext argument is not an HTTP-aware instance.  This is required to obtain a servlet request and response in order to retrieve the rememberMe cookie. Returning immediately and ignoring rememberMe operation.";
                LOGGER.debug(msg);
            }
            return null;
        }
        WebSubjectContext wsc = (WebSubjectContext)subjectContext;
        if (this.isIdentityRemoved(wsc)) {
            return null;
        }
        HttpServletRequest request = WebUtils.getHttpRequest(wsc);
        HttpServletResponse response = WebUtils.getHttpResponse(wsc);
        String base64 = this.getCookie().readValue(request, response);
        if ("deleteMe".equals(base64)) {
            return null;
        }
        if (base64 != null) {
            byte[] decoded;
            base64 = this.ensurePadding(base64);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Acquired Base64 encoded identity [" + base64 + "]");
            }
            try {
                decoded = Base64.decode(base64);
            }
            catch (RuntimeException rtEx) {
                this.getCookie().removeFrom(request, response);
                LOGGER.warn("Unable to decode existing base64 encoded entity: [" + base64 + "].", rtEx);
                return null;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Base64 decoded byte array length: " + decoded.length + " bytes.");
            }
            return decoded;
        }
        return null;
    }

    protected String ensurePadding(String base64) {
        int length = base64.length();
        if (length % 4 != 0) {
            StringBuilder sb = new StringBuilder(base64);
            while (sb.length() % 4 != 0) {
                sb.append('=');
            }
            base64 = sb.toString();
        }
        return base64;
    }

    @Override
    protected void forgetIdentity(Subject subject) {
        if (WebUtils.isHttp(subject)) {
            HttpServletRequest request = WebUtils.getHttpRequest(subject);
            HttpServletResponse response = WebUtils.getHttpResponse(subject);
            this.forgetIdentity(request, response);
        }
    }

    @Override
    public void forgetIdentity(SubjectContext subjectContext) {
        if (WebUtils.isHttp(subjectContext)) {
            HttpServletRequest request = WebUtils.getHttpRequest(subjectContext);
            HttpServletResponse response = WebUtils.getHttpResponse(subjectContext);
            this.forgetIdentity(request, response);
        }
    }

    private void forgetIdentity(HttpServletRequest request, HttpServletResponse response) {
        this.getCookie().removeFrom(request, response);
    }

    private Cookie createDefaultCookie() {
        SimpleCookie cookie = new SimpleCookie(DEFAULT_REMEMBER_ME_COOKIE_NAME);
        cookie.setHttpOnly(true);
        cookie.setMaxAge(31536000);
        return cookie;
    }
}

