/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.document;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class BigIntegerPoint
extends Field {
    public static final int BYTES = 16;
    public static final BigInteger MIN_VALUE = BigInteger.ONE.shiftLeft(127).negate();
    public static final BigInteger MAX_VALUE = BigInteger.ONE.shiftLeft(127).subtract(BigInteger.ONE);

    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 16);
        type.freeze();
        return type;
    }

    public void setBigIntegerValues(BigInteger ... point) {
        if (this.type.pointDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = BigIntegerPoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from BigInteger to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 16);
        return BigIntegerPoint.decodeDimension(bytes.bytes, bytes.offset);
    }

    private static BytesRef pack(BigInteger ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 16];
        for (int dim = 0; dim < point.length; ++dim) {
            BigIntegerPoint.encodeDimension(point[dim], packed, dim * 16);
        }
        return new BytesRef(packed);
    }

    public BigIntegerPoint(String name, BigInteger ... point) {
        super(name, BigIntegerPoint.pack(point), (IndexableFieldType)BigIntegerPoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(BigIntegerPoint.decodeDimension(bytes.bytes, bytes.offset + dim * 16));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(BigInteger value, byte[] dest, int offset) {
        NumericUtils.bigIntToSortableBytes(value, 16, dest, offset);
    }

    public static BigInteger decodeDimension(byte[] value, int offset) {
        return NumericUtils.sortableBytesToBigInt(value, offset, 16);
    }

    public static Query newExactQuery(String field, BigInteger value) {
        return BigIntegerPoint.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, BigInteger lowerValue, BigInteger upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return BigIntegerPoint.newRangeQuery(field, new BigInteger[]{lowerValue}, new BigInteger[]{upperValue});
    }

    public static Query newRangeQuery(String field, BigInteger[] lowerValue, BigInteger[] upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return new PointRangeQuery(field, BigIntegerPoint.pack((BigInteger[])lowerValue).bytes, BigIntegerPoint.pack((BigInteger[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return BigIntegerPoint.decodeDimension(value, 0).toString();
            }
        };
    }

    public static Query newSetQuery(String field, BigInteger ... values) {
        Object[] sortedValues = (BigInteger[])values.clone();
        Arrays.sort(sortedValues);
        BytesRef encoded = new BytesRef(new byte[16]);
        return new PointInSetQuery(field, 1, 16, new PointInSetQuery.Stream((BigInteger[])sortedValues, encoded){
            int upto;
            final /* synthetic */ BigInteger[] val$sortedValues;
            final /* synthetic */ BytesRef val$encoded;
            {
                this.val$sortedValues = bigIntegerArray;
                this.val$encoded = bytesRef;
            }

            @Override
            public BytesRef next() {
                if (this.upto == this.val$sortedValues.length) {
                    return null;
                }
                BigIntegerPoint.encodeDimension(this.val$sortedValues[this.upto], this.val$encoded.bytes, 0);
                ++this.upto;
                return this.val$encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 16);
                return BigIntegerPoint.decodeDimension(value, 0).toString();
            }
        };
    }
}

