/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.VariableNotBoundException;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public class ExprTripleTerm
extends ExprNode {
    private final Node_Triple tripleTerm;
    private final NodeValue nvTripleTerm;

    public ExprTripleTerm(Node node) {
        Node_Triple tripleTerm;
        if (!node.isTripleTerm()) {
            throw new ARQInternalErrorException("Not a triple term " + String.valueOf(node));
        }
        this.tripleTerm = tripleTerm = (Node_Triple)node;
        this.nvTripleTerm = tripleTerm.isConcrete() ? NodeValue.makeNode(tripleTerm) : null;
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        if (this.nvTripleTerm != null) {
            return this.nvTripleTerm;
        }
        Triple t1 = this.tripleTerm.getTriple();
        Triple t2 = Substitute.substitute(t1, binding);
        if (t2.isConcrete()) {
            Node tripleTerm2 = NodeFactory.createTripleTerm(t2);
            return NodeValue.makeNode(tripleTerm2);
        }
        throw new VariableNotBoundException("Not concrete: triple " + String.valueOf(this.tripleTerm));
    }

    public Node getNode() {
        return this.tripleTerm;
    }

    public Triple getTriple() {
        return this.tripleTerm.getTriple();
    }

    @Override
    public int hashCode() {
        return this.tripleTerm.hashCode();
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        Triple t1 = this.tripleTerm.getTriple();
        Triple t2 = Substitute.substitute(this.tripleTerm.getTriple(), binding);
        if (t2 == t1) {
            return this;
        }
        Node nodeTriple = NodeFactory.createTripleTerm(t2);
        return new ExprTripleTerm(nodeTriple);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        Node n = (Node)transform.apply(this.tripleTerm);
        return ExprLib.nodeToExpr(n);
    }

    @Override
    public boolean equals(Expr obj, boolean bySyntax) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExprTripleTerm other = (ExprTripleTerm)obj;
        return Objects.equals(this.tripleTerm, other.tripleTerm);
    }
}

