/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.Violation;
import org.apache.jena.iri.impl.AbsIRIImpl;
import org.apache.jena.iri.impl.PatternCompiler;
import org.apache.jena.iri.impl.ViolationCodeInfo;

public class ViolationImpl
extends Violation {
    static String[] componentNames;
    private final int code;
    private final int slot;
    private final AbsIRIImpl iri;

    static String componentName(int j) {
        if (componentNames == null) {
            componentNames = PatternCompiler.constantsFromClass(IRIComponents.class, 40);
        }
        return componentNames[j];
    }

    public ViolationImpl(IRI iri2, int slot, int code) {
        this.iri = (AbsIRIImpl)iri2;
        this.code = code;
        this.slot = slot;
    }

    @Override
    public int getViolationCode() {
        return this.code;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public int getComponent() {
        return this.slot;
    }

    @Override
    public String component() {
        return ViolationImpl.componentName(this.slot);
    }

    @Override
    public String codeName() {
        return PatternCompiler.errorCodeName(this.code);
    }

    @Override
    public boolean isError() {
        return (this.iri.getSchemeSpec().getMask(false) & 1L << this.code) != 0L;
    }

    @Override
    public String getShortMessage() {
        return "<" + String.valueOf(this.getIRI()) + "> Code: " + this.code + "/" + this.codeName() + " in " + this.component() + ": " + this.description();
    }

    private String description() {
        ViolationCodeInfo info = ViolationCodeInfo.all[this.code];
        if (info == null) {
            return "internal error: description of error not found";
        }
        return info.description(this.slot, this.iri);
    }

    @Override
    public String getLongMessage() {
        return "<" + String.valueOf(this.getIRI()) + "> Code: " + this.code + "/" + this.codeName() + " in " + this.component() + ": " + this.description() + " see: " + this.specs();
    }

    private String specs() {
        ViolationCodeInfo info = ViolationCodeInfo.all[this.code];
        if (info == null) {
            return "(null)";
        }
        return info.specs(this.slot, this.iri.getFactory(), this.iri.getScheme());
    }

    @Override
    public String getSpecificationURL() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

