/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt.userinfo;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;

public class UserinfoResponse {
    private final String sub;
    private final Optional<String> preferredUsername;
    private final Optional<String> email;
    private final JsonNode json;

    public UserinfoResponse(JsonNode json) {
        this.json = json;
        this.preferredUsername = Optional.ofNullable(json.get("preferred_username")).map(JsonNode::asText);
        this.sub = Optional.ofNullable(json.get("sub")).map(JsonNode::asText).orElse(null);
        this.email = Optional.ofNullable(json.get("email")).map(JsonNode::asText);
    }

    public String getSub() {
        return this.sub;
    }

    public Optional<String> getPreferredUsername() {
        return this.preferredUsername;
    }

    public Optional<String> getEmail() {
        return this.email;
    }

    public Optional<String> claimByPropertyName(String propertyName) {
        return Optional.ofNullable(this.json.get(propertyName)).map(JsonNode::asText);
    }
}

