/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.dropwizard;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MovingAverages;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowMovingAverages;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jmx.JmxReporter;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.metrics.dropwizard.DropWizardMetric;
import org.apache.james.metrics.dropwizard.DropWizardTimeMetric;
import org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramReservoir;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DropWizardMetricFactory
implements MetricFactory,
Startable {
    private final MetricRegistry metricRegistry;
    private final JmxReporter jmxReporter;

    @Inject
    public DropWizardMetricFactory(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).build();
    }

    public Metric generate(String name) {
        return new DropWizardMetric(this.metricRegistry.meter(name, () -> new Meter((MovingAverages)new SlidingTimeWindowMovingAverages())), name);
    }

    public DropWizardTimeMetric timer(String name) {
        return new DropWizardTimeMetric(name, this.metricRegistry.timer(name, () -> new Timer((Reservoir)new HdrHistogramReservoir())));
    }

    public <T> Publisher<T> decoratePublisherWithTimerMetric(String name, Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            return Mono.using(() -> this.timer(name), any -> Mono.from((Publisher)publisher), DropWizardTimeMetric::stopAndPublish);
        }
        return Flux.using(() -> this.timer(name), any -> publisher, DropWizardTimeMetric::stopAndPublish);
    }

    public <T> Publisher<T> decoratePublisherWithTimerMetricLogP99(String name, Publisher<T> publisher) {
        return Flux.using(() -> this.timer(name), any -> publisher, timer -> timer.stopAndPublish().logWhenExceedP99(TimeMetric.ExecutionResult.DEFAULT_100_MS_THRESHOLD));
    }

    @PostConstruct
    public void start() {
        this.jmxReporter.start();
    }

    @PreDestroy
    public void stop() {
        this.jmxReporter.stop();
        this.metricRegistry.removeMatching((name, metric) -> true);
    }
}

