/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.apache.ratis.util.Timestamp;

class FollowerInfoImpl
implements FollowerInfo {
    private final String name;
    private final AtomicReference<RaftPeer> peer;
    private final Function<RaftPeerId, RaftPeer> getPeer;
    private final AtomicReference<Timestamp> lastRpcResponseTime;
    private final AtomicReference<Timestamp> lastRpcSendTime;
    private final AtomicReference<Timestamp> lastHeartbeatSendTime;
    private final AtomicReference<Timestamp> lastRespondedAppendEntriesSendTime;
    private final RaftLogIndex nextIndex;
    private final RaftLogIndex matchIndex = new RaftLogIndex((Object)"matchIndex", -1L);
    private final RaftLogIndex commitIndex = new RaftLogIndex((Object)"commitIndex", -1L);
    private final RaftLogIndex snapshotIndex = new RaftLogIndex((Object)"snapshotIndex", 0L);
    private volatile boolean caughtUp;
    private volatile boolean ackInstallSnapshotAttempt = false;

    FollowerInfoImpl(RaftGroupMemberId id, RaftPeer peer, Function<RaftPeerId, RaftPeer> getPeer, Timestamp lastRpcTime, long nextIndex, boolean caughtUp) {
        this.name = id + "->" + peer.getId();
        this.peer = new AtomicReference<RaftPeer>(peer);
        this.getPeer = getPeer;
        this.lastRpcResponseTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRpcSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastHeartbeatSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.lastRespondedAppendEntriesSendTime = new AtomicReference<Timestamp>(lastRpcTime);
        this.nextIndex = new RaftLogIndex((Object)"nextIndex", nextIndex);
        this.caughtUp = caughtUp;
    }

    private void info(Object message) {
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: {}", (Object)this.name, message);
        }
    }

    private void info(String prefix, Object message) {
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: {} {}", new Object[]{this.name, prefix, message});
        }
    }

    private void debug(Object message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: {}", (Object)this.name, message);
        }
    }

    private void debug(String prefix, Object message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: {} {}", new Object[]{this.name, prefix, message});
        }
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    public boolean updateMatchIndex(long newMatchIndex) {
        return this.matchIndex.updateToMax(newMatchIndex, this::debug);
    }

    public long getCommitIndex() {
        return this.commitIndex.get();
    }

    public boolean updateCommitIndex(long newCommitIndex) {
        return this.commitIndex.updateToMax(newCommitIndex, this::debug);
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex.get();
    }

    public long getNextIndex() {
        return this.nextIndex.get();
    }

    public void increaseNextIndex(long newNextIndex) {
        this.nextIndex.updateIncreasingly(newNextIndex, this::debug);
    }

    public void decreaseNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> old <= 0L ? old : Math.min(old - 1L, newNextIndex), message -> this.info("decreaseNextIndex", message));
    }

    public void setNextIndex(long newNextIndex) {
        this.nextIndex.updateUnconditionally(old -> newNextIndex >= 0L ? newNextIndex : old, message -> this.info("setNextIndex", message));
    }

    public void updateNextIndex(long newNextIndex) {
        this.nextIndex.updateToMax(newNextIndex, message -> this.debug("updateNextIndex", message));
    }

    public void computeNextIndex(LongUnaryOperator op) {
        this.nextIndex.updateUnconditionally(op, message -> this.info("computeNextIndex", message));
    }

    public void setSnapshotIndex(long newSnapshotIndex) {
        this.snapshotIndex.setUnconditionally(newSnapshotIndex, this::info);
        this.matchIndex.setUnconditionally(newSnapshotIndex, this::info);
        this.nextIndex.setUnconditionally(newSnapshotIndex + 1L, this::info);
    }

    public void setAttemptedToInstallSnapshot() {
        LOG.info("Follower {} acknowledged installing snapshot", (Object)this.name);
        this.ackInstallSnapshotAttempt = true;
    }

    public boolean hasAttemptedToInstallSnapshot() {
        return this.ackInstallSnapshotAttempt;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(c" + this.getCommitIndex() + ",m" + this.getMatchIndex() + ",n" + this.getNextIndex() + ", caughtUp=" + this.caughtUp + ", lastRpcSendTime=" + this.lastRpcSendTime.get().elapsedTimeMs() + ", lastRpcResponseTime=" + this.lastRpcResponseTime.get().elapsedTimeMs() + ")";
    }

    void catchUp() {
        this.caughtUp = true;
    }

    boolean isCaughtUp() {
        return this.caughtUp;
    }

    public RaftPeerId getId() {
        return this.peer.get().getId();
    }

    public RaftPeer getPeer() {
        RaftPeer newPeer = this.getPeer.apply(this.getId());
        if (newPeer != null) {
            this.peer.set(newPeer);
            return newPeer;
        }
        return this.peer.get();
    }

    public void updateLastRpcResponseTime() {
        this.lastRpcResponseTime.set(Timestamp.currentTime());
    }

    public Timestamp getLastRpcResponseTime() {
        return this.lastRpcResponseTime.get();
    }

    public Timestamp getLastRpcSendTime() {
        return this.lastRpcSendTime.get();
    }

    public void updateLastRpcSendTime(boolean isHeartbeat) {
        Timestamp currentTime = Timestamp.currentTime();
        this.lastRpcSendTime.set(currentTime);
        if (isHeartbeat) {
            this.lastHeartbeatSendTime.set(currentTime);
        }
    }

    public Timestamp getLastRpcTime() {
        return Timestamp.latest((Timestamp)this.lastRpcResponseTime.get(), (Timestamp)this.lastRpcSendTime.get());
    }

    public Timestamp getLastHeartbeatSendTime() {
        return this.lastHeartbeatSendTime.get();
    }

    public Timestamp getLastRespondedAppendEntriesSendTime() {
        return this.lastRespondedAppendEntriesSendTime.get();
    }

    public void updateLastRespondedAppendEntriesSendTime(Timestamp sendTime) {
        this.lastRespondedAppendEntriesSendTime.set(sendTime);
    }
}

