/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ExtendRegion
extends Statement {
    private final int regionId;
    private final int dataNodeId;

    public ExtendRegion(int regionId, int dataNodeId) {
        super(null);
        this.regionId = regionId;
        this.dataNodeId = dataNodeId;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(ExtendRegion.class, this.regionId, this.dataNodeId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtendRegion)) {
            return false;
        }
        ExtendRegion another = (ExtendRegion)obj;
        return this.regionId == another.regionId && this.dataNodeId == another.dataNodeId;
    }

    @Override
    public String toString() {
        return String.format("extend region %d to datanode %d", this.regionId, this.dataNodeId);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExtendRegion(this, context);
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }
}

